<?php
$VerEditor = auth()->user()->can('Productos - Editor')
?>
<?php if($VerEditor): ?>

<?php $__env->startSection('tituloModulo', 'DATOS DEL PRODUCTO'); ?>
<?php $__env->startSection('contenido'); ?>
<div class="card">
    <div class="card-body">
        <form action="<?php echo e(route('productos.update', $datos->codigo_prod)); ?>" method="POST"  enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <div class="row mt-2">
                <div class="col-md-12 col-12 text-center">
                    <?php if($datos->imagen_principal_prod): ?>
                    <img src="<?php echo e(asset('assets/img/productos/' . $datos->imagen_principal_prod)); ?>" alt="Producto" width="250" >
                    <?php else: ?>
                    <img src="<?php echo asset('assets/img/products.png'); ?>" alt="Profile" width="150" height="250" >
                    <?php endif; ?>
                </div>
                <div class="col-md-6 col-12">
                    <label class="control-label is-required">SKU</label>
                    <input class="form-control" name="sku" value="<?php echo e($datos->sku_prod); ?>" type="text" required>
                </div>
                <div class="col-md-6 col-12">
                    <label class="control-label">Imagen principal</label>
                    <input class="form-control" name="imagenPrincipal"  type="file">
                </div>
                <div class="col-md-12 col-12">
                    <label class="control-label is-required">Nombre</label>
                    <input class="form-control" name="nombre" value="<?php echo e($datos->nombre_prod); ?>"type="text" required>
                </div>
                <div class="col-md-6 col-12">
                    <label class="control-label is-required">Categoría de producto</label>
                    <select class="form-select "  name="categoria" id="categoria" required>
                        <option value="<?php echo e($datos->codigo_prca); ?>"><?php echo e($datos->nombre_prca); ?></option>
                        <?php $__currentLoopData = $categorias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $categoria): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($categoria->codigo_prca); ?>"><?php echo e($categoria->nombre_prca); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-md-6 col-12">
                    <label class="control-label is-required">Subcategoría de producto</label>
                    <select class="form-select "  name="subcategoria" id="subcategoria" required>
                        <option value="<?php echo e($datos->codigo_prsu); ?>"><?php echo e($datos->nombre_prsu); ?></option>
                        <?php $__currentLoopData = $subcategorias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subcategoria): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($subcategoria->codigo_prsu); ?>"><?php echo e($subcategoria->nombre_prsu); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <?php if($conteoTallas == 0): ?>
                <div class="col-md-6 col-12">
                    <label class="control-label">Compra</label>
                    <input id="input-currency" class="form-control input-mask text-left"
                    data-inputmask="'alias': 'numeric', 'groupSeparator': '', 'digits': 0, 'digitsOptional': false, 'prefix': '$ ', 'placeholder': '0'"
                    name="compra" value="<?php echo e($datos->compra_prod); ?>">
                </div>
                <div class="col-md-6 col-12">
                    <label class="control-label">Venta</label>
                    <input id="input-currency" class="form-control input-mask text-left"
                    data-inputmask="'alias': 'numeric', 'groupSeparator': '', 'digits': 0, 'digitsOptional': false, 'prefix': '$ ', 'placeholder': '0'"
                    name="venta" value="<?php echo e($datos->venta_prod); ?>">
                </div>
                <div class="col-md-6 col-12">
                    <label class="control-label is-required">Stock</label>
                    <input class="form-control" name="stock" value="<?php echo e($datos->stock_prod); ?>" type="number" >
                </div>
                <?php endif; ?>
                <div class="col-md-6 col-12">
                    <label class="control-label is-required">Marca</label>
                    <select class="form-select "  name="marca" id="marca" required>
                        <?php if($datos->marca_prod): ?>
                        <option value="<?php echo e($datos->codigo_prma); ?>"><?php echo e($datos->nombre_prma); ?></option>
                        <?php else: ?>
                        <option value="">Seleccione una marca</option>
                        <?php endif; ?>
                        <?php $__currentLoopData = $marcas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $marca): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($marca->codigo_prma); ?>"><?php echo e($marca->nombre_prma); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-md-6 col-12">
                    <label class="control-label">¿EL producto estará en línea?</label>
                    <select class="form-select "  name="linea" required>
                        <?php if($datos->linea_prod): ?>
                        <option value="<?php echo e($datos->linea_prod); ?>"><?php echo e($datos->linea_prod); ?></option>
                        <?php else: ?>
                        <option value="">Seleccione una opción</option>
                        <?php endif; ?>
                        <option value="Si">Si</option>
                        <option value="No">No</option>
                    </select>
                </div>
                <div class="col-md-6 col-12">
                    <label class="control-label">¿EL producto estará en la sección de ofertas?</label>
                    <select class="form-select "  name="oferta" required>
                        <?php if($datos->ofertas_prod): ?>
                        <option value="<?php echo e($datos->ofertas_prod); ?>"><?php echo e($datos->ofertas_prod); ?></option>
                        <?php else: ?>
                        <option value="">Seleccione una opción</option>
                        <?php endif; ?>
                        <option value="Si">Si</option>
                        <option value="No">No</option>
                    </select>
                </div>
                <div class="col-md-6 col-12">
                    <label class="control-label">¿EL producto estará en la sección de nuevos productos?</label>
                    <select class="form-select "  name="nuevos" required>
                        <?php if($datos->nuevo_prod): ?>
                        <option value="<?php echo e($datos->nuevo_prod); ?>"><?php echo e($datos->nuevo_prod); ?></option>
                        <?php else: ?>
                        <option value="">Seleccione una opción</option>
                        <?php endif; ?>
                        <option value="Si">Si</option>
                        <option value="No">No</option>
                    </select>
                </div>
                <div class="col-md-12 col-12">
                    <label class="control-label is-required">Descripción corta</label>
                    <div id="editor"><?php echo $datos->descripcion_corta_prod; ?></div>
                    <textarea name="descripcion_corta" style="display:none"><?php echo $datos->descripcion_corta_prod; ?></textarea>
                    <script>
                        ClassicEditor
                            .create( document.querySelector( '#editor' ) )
                            .then( editor => {
                                editor.model.document.on('change:data', () => {
                                    document.querySelector('textarea[name="descripcion_corta"]').value = editor.getData();
                                });
                            })
                            .catch( error => {
                                console.error( error );
                            } );
                    </script>
                </div>
                <div class="col-md-12 col-12">
                    <label class="control-label is-required">Descripción larga</label>
                    <div id="descripcionLarga"><?php echo $datos->descripcion_larga_prod; ?></div>
                    <textarea name="descripcion_larga" style="display:none"><?php echo $datos->descripcion_larga_prod; ?></textarea>
                    <script>
                        ClassicEditor
                            .create( document.querySelector( '#descripcionLarga' ) )
                            .then( descripcionLarga => {
                                descripcionLarga.model.document.on('change:data', () => {
                                    document.querySelector('textarea[name="descripcion_larga"]').value = descripcionLarga.getData();
                                });
                            })
                            .catch( error => {
                                console.error( error );
                            } );
                    </script>
                </div>
            </div>
            <button type="submit" class="btn btn-success mt-3" data-bs-toggle="modal" data-bs-target="#crear">
                <i class="bx  bxs-save"></i> Guardar
            </button>
        </form>
    </div>
</div>
<div class="card">
    <div class="card-body">
        <h5 class="card-title">Tallas</h5>
        <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#crearTalla<?php echo e($datos->codigo_prod); ?>">
            <i class="bx bxs-folder-plus"></i> Agregar talla
        </button>
        <div class="datatable-wrapper datatable-loading no-footer sortable searchable fixed-columns">
            <div class="datatable-container">
                <table class="table datatable datatable-table">
                    <thead>
                        <tr class="text">
                            <th data-sortable="true" scope="col">TALLA</th>
                            <th data-sortable="true" scope="col">COMPRA</th>
                            <th data-sortable="true" scope="col">VENTA</th>
                            <th data-sortable="true" scope="col">STOCK</th>
                            <th data-sortable="true" scope="col">ACCIÓN</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $tallas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $talla): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td data-title="TALLA"><?php echo e($talla->talla_prta); ?></td>
                            <td data-title="TALLA"><?php echo e("$" . number_format($talla->compra_prta, 2)); ?></td>
                            <td data-title="TALLA"><?php echo e("$" . number_format($talla->venta_prta, 2)); ?></td>
                            <td data-title="TALLA"><?php echo e($talla->stock_prta); ?></td>
                            <td data-title="ACCIÓN">
                                <div class="btn-group">
                                    <button type="button" class="btn btn-outline-primary dropdown-toggle btnTabla"
                                        data-bs-toggle="dropdown" aria-expanded="false">Acción <i
                                            class="mdi mdi-chevron-down"></i></button>
                                    <div class="dropdown-menu">
                                        <button type="button" class="btn btn-outline-success mt-2 dropdown-item" data-bs-toggle="modal" data-bs-target="#editar<?php echo e($talla->codigo_prta); ?>">
                                            <i class="bx bxs-edit"></i> Editar
                                        </button>
                                        <form action="<?php echo e(route('productos.delete.talla', $talla->codigo_prta)); ?>" method="POST" enctype="multipart/form-data" class="form-delete">
                                            <?php echo csrf_field(); ?>
                                            <button class="dropdown-item"   type="submit" id="btn" >
                                                <i class="bx  bxs-trash"></i> Eliminar
                                            </button>
                                        </form>
                                    </div>
                                </div>
                            </td>
                        </tr>
                        <div class="modal fade" id="editar<?php echo e($talla->codigo_prta); ?>" tabindex="-1">
                            <div class="modal-dialog modal-lg">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title">Editar talla</h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                    </div>
                                    <form action="<?php echo e(route('productos.update.tallas',  $talla->codigo_prta)); ?>" method="POST">
                                        <?php echo csrf_field(); ?>
                                    <div class="modal-body">
                                        <div class="row">
                                            <div class="col-md-12 col-12">
                                                <label class="control-label is-required">Talla del producto</label>
                                                <select class="form-select" aria-label="Default select example" name="talla" required>
                                                    <option value="<?php echo e($talla->talla_prta); ?>"><?php echo e($talla->talla_prta); ?></option>
                                                    <option value="XS">XS</option>
                                                    <option value="S">S</option>
                                                    <option value="M">M</option>
                                                    <option value="L">L</option>
                                                    <option value="XL">XL</option>
                                                    <option value="XXL">XXL</option>
                                                    <option value="3">3</option>
                                                    <option value="5">5</option>
                                                    <option value="7">7</option>
                                                    <option value="9">9</option>
                                                </select>
                                            </div>
                                            <div class="col-md-6 col-12">
                                                <label class="control-label is-required">Costo de compra</label>
                                                <input id="input-currency" value="<?php echo e($talla->compra_prta); ?>" class="form-control input-mask text-left" data-inputmask="'alias': 'numeric', 'groupSeparator': '', 'digits': 2, 'digitsOptional': false, 'prefix': '$', 'placeholder': '0'" name="compra"  required>
                                            </div>
                                            <div class="col-md-6 col-12">
                                                <label class="control-label">Costo de venta</label>
                                                <input id="input-currency" value="<?php echo e($talla->venta_prta); ?>" class="form-control input-mask text-left" data-inputmask="'alias': 'numeric', 'groupSeparator': '', 'digits': 2, 'digitsOptional': false, 'prefix': '$', 'placeholder': '0'" name="venta" required>
                                            </div>
                                            <div class="col-md-12 col-12">
                                                <label class="control-label">Stock</label>
                                            <input class="form-control" value="<?php echo e($talla->stock_prta); ?>" name="stock" value="<?php echo e($datos->stock_prod); ?>" type="number" min="1" max="1500" required>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="submit" class="btn btn-success"><i class="bx bx-save"></i> Actualizar</button>
                                        <button type="button" class="btn btn-danger" data-bs-dismiss="modal"><i class="bx  bxs-x-circle"></i> Cerrar</button>
                                    </div>
                                    </form>
                                </div>
                            </div>
                        </div>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
            <div class="datatable-bottom">
                <nav class="datatable-pagination">
                    <ul class="datatable-pagination-list"></ul>
                </nav>
            </div>
        </div>
    </div>
</div>
<div class="card">
    <div class="card-body">
        <h5 class="card-title">Colores</h5>
        <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#crearColor<?php echo e($datos->codigo_prod); ?>">
            <i class="bx bxs-folder-plus"></i> Agregar color
        </button>
        <div class="datatable-wrapper datatable-loading no-footer sortable searchable fixed-columns">
            <div class="datatable-container">
                <table class="table datatable datatable-table">
                    <thead>
                        <tr class="text">
                            <th data-sortable="true" scope="col">COLOR</th>
                            <th data-sortable="true" scope="col">ACCIÓN</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $colores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $color): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td data-title="COLOR"><input type="color" class="form-control" style="width: 100%;" name="colorProducto" value="<?php echo e($color->color_prco); ?>" disabled></td>
                            <td data-title="ACCIÓN">
                                <div class="btn-group">
                                    <button type="button" class="btn btn-outline-primary dropdown-toggle btnTabla"
                                        data-bs-toggle="dropdown" aria-expanded="false">Acción <i
                                            class="mdi mdi-chevron-down"></i></button>
                                    <div class="dropdown-menu">
                                        <form action="<?php echo e(route('productos.delete.color', $color->codigo_prco)); ?>" method="POST" enctype="multipart/form-data" class="form-delete">
                                            <?php echo csrf_field(); ?>
                                            <button class="dropdown-item"   type="submit" id="btn" >
                                                <i class="bx  bxs-trash"></i> Eliminar
                                            </button>
                                        </form>
                                    </div>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
            <div class="datatable-bottom">
                <nav class="datatable-pagination">
                    <ul class="datatable-pagination-list"></ul>
                </nav>
            </div>
        </div>
    </div>
</div>
<div class="card">
    <div class="card-body">
        <h5 class="card-title">Imagenes secundarias</h5>
        <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#crearImagen<?php echo e($datos->codigo_prod); ?>">
            <i class="bx bxs-folder-plus"></i> Agregar imagen secundaria
        </button>
        <div class="datatable-wrapper datatable-loading no-footer sortable searchable fixed-columns">
            <div class="datatable-container">
                <table class="table datatable datatable-table">
                    <thead>
                        <tr class="text">
                            <th data-sortable="true" scope="col">IMAGEN</th>
                            <th data-sortable="true" scope="col">ACCIÓN</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $imagenes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $imagen): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td data-title="IMAGEN"><img src="<?php echo e(asset('assets/img/productos/' . $imagen->imagen_prim)); ?>" alt="Producto" width="100" >
                            </td>
                            <td data-title="ACCIÓN">
                                <div class="btn-group">
                                    <button type="button" class="btn btn-outline-primary dropdown-toggle btnTabla"
                                        data-bs-toggle="dropdown" aria-expanded="false">Acción <i
                                            class="mdi mdi-chevron-down"></i></button>
                                    <div class="dropdown-menu">
                                        <form action="<?php echo e(route('productos.delete.imagen', $imagen->codigo_prim)); ?>" method="POST" enctype="multipart/form-data" class="form-delete">
                                            <?php echo csrf_field(); ?>
                                            <button class="dropdown-item"   type="submit" id="btn" >
                                                <i class="bx  bxs-trash"></i> Eliminar
                                            </button>
                                        </form>
                                    </div>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
            <div class="datatable-bottom">
                <nav class="datatable-pagination">
                    <ul class="datatable-pagination-list"></ul>
                </nav>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="crearImagen<?php echo e($datos->codigo_prod); ?>" tabindex="-1">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Agregar imagen</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="<?php echo e(route('productos.store.imagen', $datos->codigo_prod)); ?>" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
            <div class="modal-body">
                <input class="form-control" name="imagen"  type="file">
            </div>
            <div class="modal-footer">
                <button type="submit" class="btn btn-success"><i class="bx bx-save"></i> Guardar</button>
                <button type="button" class="btn btn-danger" data-bs-dismiss="modal"><i class="bx  bxs-x-circle"></i> Cerrar</button>
            </div>
            </form>
        </div>
    </div>
</div>
<div class="modal fade" id="crearColor<?php echo e($datos->codigo_prod); ?>" tabindex="-1">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Agregar color</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="<?php echo e(route('productos.store.color', $datos->codigo_prod)); ?>" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
            <div class="modal-body">
                <div class="form-group">
                <label class="control-label is-required">Color del producto</label>
                    <input type="color" class="form-control form-control-color" style="width: 100%;" name="colorProducto" value="#4154f1" title="Seleccona el color del producto">
                </div>
            </div>
            <div class="modal-footer">
                <button type="submit" class="btn btn-success"><i class="bx bx-save"></i> Guardar</button>
                <button type="button" class="btn btn-danger" data-bs-dismiss="modal"><i class="bx  bxs-x-circle"></i> Cerrar</button>
            </div>
            </form>
        </div>
    </div>
</div>
<div class="modal fade" id="crearTalla<?php echo e($datos->codigo_prod); ?>" tabindex="-1">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Agregar talla</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="<?php echo e(route('productos.store.talla', $datos->codigo_prod)); ?>" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-12 col-12">
                        <label class="control-label is-required">Talla del producto</label>
                        <select class="form-select" aria-label="Default select example" name="talla" required>
                            <option value="">Selecciona  la talla</option>
                            <option value="XS">XS</option>
                            <option value="S">S</option>
                            <option value="M">M</option>
                            <option value="L">L</option>
                            <option value="XL">XL</option>
                            <option value="XXL">XXL</option>
                            <option value="3">3</option>
                            <option value="5">5</option>
                            <option value="7">7</option>
                            <option value="9">9</option>
                        </select>
                    </div>
                    <div class="col-md-6 col-12">
                        <label class="control-label is-required">Costo de compra</label>
                        <input id="input-currency" class="form-control input-mask text-left" data-inputmask="'alias': 'numeric', 'groupSeparator': '', 'digits': 2, 'digitsOptional': false, 'prefix': '$', 'placeholder': '0'" name="compra"  required>
                    </div>
                    <div class="col-md-6 col-12">
                        <label class="control-label">Costo de venta</label>
                        <input id="input-currency" class="form-control input-mask text-left" data-inputmask="'alias': 'numeric', 'groupSeparator': '', 'digits': 2, 'digitsOptional': false, 'prefix': '$', 'placeholder': '0'" name="venta" required>
                    </div>
                    <div class="col-md-12 col-12">
                        <label class="control-label">Stock</label>
                    <input class="form-control" name="stock" value="<?php echo e($datos->stock_prod); ?>" type="number" min="1" max="1500" required>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="submit" class="btn btn-success"><i class="bx bx-save"></i> Guardar</button>
                <button type="button" class="btn btn-danger" data-bs-dismiss="modal"><i class="bx  bxs-x-circle"></i> Cerrar</button>
            </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php endif; ?>


<?php echo $__env->make('layouts/app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\keninails\resources\views/productos/dats.blade.php ENDPATH**/ ?>