<?php $__env->startSection('contenido'); ?>
<!-- Navbar Start -->
    <style>
        .color-circle {
            display: inline-block;
            width: 20px;
            height: 20px;
            border-radius: 50%;
            margin-right: 10px;
        }
        @media (max-width: 768px) {
            h4.toggle-all {
                font-size: 1.2em; /* Tamaño de la letra más pequeño en móviles */
            }
            h5.toggle-section {
                font-size: 1em; /* Tamaño de la letra más pequeño en móviles */
            }
        }
    </style>
    <div class="container-fluid">
        <div class="row border-top px-xl-5">
            <div class="col-lg-3 d-none d-lg-block">
                <a class="btn shadow-none d-flex align-items-center justify-content-between text-white w-100 color-principal" data-toggle="collapse" href="#navbar-vertical" style="height: 65px; margin-top: -1px; padding: 0 30px; background-color: #ffffff;">
                    <h6 class="m-0">Categorías</h6>
                    <i class="fa fa-angle-down text-dark"></i>
                </a>
                <nav class="collapse position-absolute navbar navbar-vertical navbar-light align-items-start p-0 border border-top-0 border-bottom-0 bg-light" id="navbar-vertical" style="width: calc(100% - 30px); z-index: 1;">
                    <div class="navbar-nav w-100 overflow-hidden" style="height: 410px">
                        <div class="nav-item dropdown">
                            <a href="#" class="nav-link" data-toggle="dropdown">Subcategoría <i class="fa fa-angle-down float-right mt-1"></i></a>
                            <div class="dropdown-menu position-absolute bg-secondary border-0 rounded-0 w-100 m-0">
                                <?php $__currentLoopData = $subcategorias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subcategoria): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <form action="<?php echo e(route('filtro')); ?>" method="POST" id="form-<?php echo e($subcategoria->codigo_prsu); ?>">
                                    <?php echo csrf_field(); ?>
                                    <a href="#" class="dropdown-item" onclick="document.getElementById('form-<?php echo e($subcategoria->codigo_prsu); ?>').submit(); return false;">
                                    <?php echo e($subcategoria->nombre_prsu); ?></a>
                                    <input type="hidden" name="subcategoria[]" value="<?php echo e($subcategoria->codigo_prsu); ?>">
                                </form>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                        <?php $__currentLoopData = $categorias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $categoria): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <form action="<?php echo e(route('filtro')); ?>" method="POST" id="form-<?php echo e($categoria->codigo_prca); ?>">
                            <?php echo csrf_field(); ?>
                            <a href="#" class="nav-item nav-link" onclick="document.getElementById('form-<?php echo e($categoria->codigo_prca); ?>').submit(); return false;">
                            <?php echo e($categoria->nombre_prca); ?></a>
                            <input type="hidden" name="categoria[]" value="<?php echo e($categoria->codigo_prca); ?>">
                        </form>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </nav>
            </div>
            <div class="col-lg-9">
                <nav class="navbar navbar-expand-lg bg-light navbar-light py-3 py-lg-0 px-0">
                    <a href="" class="text-decoration-none d-block d-lg-none">
                        <h1 class="m-0 display-5 font-weight-semi-bold"><img alt="logo" class="logo_empresa" width="50"><span class="nombre_empresa"></span></h1>
                    </a>
                    <button type="button" class="navbar-toggler" data-toggle="collapse" data-target="#navbarCollapse">
                        <span class="navbar-toggler-icon"></span>
                    </button>
                    <div class="collapse navbar-collapse justify-content-between" id="navbarCollapse">
                        <div class="navbar-nav mr-auto py-0">
                            <a href="<?php echo e(route('index')); ?>" class="nav-item nav-link active">Inicio</a>
                            <a href="<?php echo e(route('catalogo')); ?>" class="nav-item nav-link">Tienda</a>
                            <a href="<?php echo e(route('carrito')); ?>" class="nav-item nav-link">Carrito</a>
                            <a href="<?php echo e(route('eventos')); ?>" class="nav-item nav-link">Eventos</a>
                            <a href="https://elblogdelauto.com" class="nav-item nav-link">Nosotros</a>
                            <a href="<?php echo e(route('contacto')); ?>" class="nav-item nav-link">Contacto</a>
                        </div>
                        <div class="navbar-nav ml-auto py-0">
                            <?php if(Auth::check()): ?>
                            <a href="<?php echo e(route('home')); ?>" class="nav-item nav-link">Panel de control</a>
                            <?php else: ?>
                            <a href="<?php echo e(route('login')); ?>" class="nav-item nav-link">Acceso</a>
                            <a href="<?php echo e(route('register')); ?>" class="nav-item nav-link">Registro</a>
                            <?php endif; ?>
                        </div>
                    </div>
                </nav>
            </div>
        </div>
    </div>
    <!--HEADER INICIO -->
    <div class="container-fluid">
        <div class="d-flex flex-column align-items-center justify-content-center" style="min-height: 50px">
            <h1 class="font-weight-semi-bold text-uppercase">Nuestra tienda</h1>
            <div class="d-inline-flex">
                <p class="m-0"><a href="<?php echo e(route('index')); ?>" class="color-principal-color" >Inicio</a></p>
                <p class="m-0 px-2">-</p>
                <p class="m-0">Catálogo</p>
            </div>
        </div>
    </div>
    <!-- HEADER FIN-->
    <!-- CONTENIDO INICIO-->
    <div class="container-fluid pt-5">
        <div class="row px-xl-5">
            <!-- Shop Sidebar Start -->
            <div class="col-lg-3 col-md-12">
                <form action="<?php echo e(route('filtro')); ?>"  method="POST">
                    <?php echo csrf_field(); ?>
                    <h4 class="font-weight-semi-bold toggle-all">FILTROS <i class="fas fa-chevron-up"></i></h4>
                    <div class="all-filters">
                        <div class="border-bottom">
                            <h5 class="font-weight-semi-bold toggle-section">Categorías <i class="fas fa-chevron-up"></i></h5>
                            <div class="content">
                                <?php $__currentLoopData = $categorias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $categoria): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="custom-control custom-checkbox d-flex align-items-center justify-content-between">
                                    <input type="checkbox" name="categoria[]" value="<?php echo e($categoria->codigo_prca); ?>"
                                    <?php if($categoriaSelecconado && in_array($categoria->codigo_prca, $categoriaSelecconado)): ?> checked <?php endif; ?>
                                    class="custom-control-input" id="categoria-<?php echo e($categoria->codigo_prca); ?>">
                                    <label class="custom-control-label" for="categoria-<?php echo e($categoria->codigo_prca); ?>"><?php echo e($categoria->nombre_prca); ?></label>
                                    <span class="badge border font-weight-normal"><?php echo e($categoria->total_productos); ?></span>
                                </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                        <div class="border-bottom">
                            <h5 class="font-weight-semi-bold toggle-section">Subcategorías <i class="fas fa-chevron-up"></i></h5>
                            <div class="content">
                                <?php $__currentLoopData = $subcategorias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subcategoria): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="custom-control custom-checkbox d-flex align-items-center justify-content-between">
                                    <input type="checkbox" name="subcategoria[]" value="<?php echo e($subcategoria->codigo_prsu); ?>" class="custom-control-input" id="subcategoria-<?php echo e($subcategoria->codigo_prsu); ?>"
                                    <?php if($subcategoriaSelecconado && in_array($subcategoria->codigo_prsu, $subcategoriaSelecconado)): ?> checked <?php endif; ?>>
                                    <label class="custom-control-label" for="subcategoria-<?php echo e($subcategoria->codigo_prsu); ?>"><?php echo e($subcategoria->nombre_prsu); ?></label>
                                    <span class="badge border font-weight-normal"><?php echo e($subcategoria->total_productos); ?></span>
                                </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                        <div class="border-bottom">
                            <h5 class="font-weight-semi-bold toggle-section">Marcas <i class="fas fa-chevron-up"></i></h5>
                            <div class="content">
                                <?php $__currentLoopData = $marcas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $marca): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="custom-control custom-checkbox d-flex align-items-center justify-content-between">
                                    <input type="checkbox" name="marca[]" value="<?php echo e($marca->codigo_prma); ?>" class="custom-control-input" id="marca-<?php echo e($marca->codigo_prma); ?>"
                                    <?php if($marcaSelecconado && in_array($marca->codigo_prma, $marcaSelecconado)): ?> checked <?php endif; ?>>
                                    <label class="custom-control-label" for="marca-<?php echo e($marca->codigo_prma); ?>"><?php echo e($marca->nombre_prma); ?></label>
                                    <span class="badge border font-weight-normal"><?php echo e($marca->total_productos); ?></span>
                                </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                        <div class="border-bottom">
                            <h5 class="font-weight-semi-bold toggle-section">Rango de precio <i class="fas fa-chevron-up"></i></h5>
                            <div class="content">
                                <div class="title" data-count="2">
                                    <div class="content-block">
                                        <div class="row">
                                            <div class="col-sm-6 col-6">
                                                <p>Precio Min:</p>
                                                <input type="number" class="form-control" name="precio_min" min="1"
                                                <?php if($precio_minSeleccionado): ?>
                                                    value="<?php echo e($precio_minSeleccionado); ?>"
                                                <?php endif; ?>
                                                placeholder="0">
                                            </div>
                                            <div class="col-sm-6 col-6">
                                                <p>Precio Max:</p>
                                                <input type="number" class="form-control" name="precio_max" max="2500"
                                                <?php if($precio_maxSeleccionado): ?>
                                                value="<?php echo e($precio_maxSeleccionado); ?>"
                                                <?php endif; ?>
                                                placeholder="3500">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <div class="card-footer d-flex justify-content-between bg-light border">
                    <button type="submit" class="btn btn-sm text-dark p-0"><i class="fas fa-filter mr-1 color-principal-color"></i>Filtrar</button>
                    <a href="<?php echo e(route('catalogo')); ?>" class="btn btn-sm text-dark p-0"><i class="fas fa-eraser  mr-1 color-principal-color"></i>Borrar</a>
                </div>
                </form>
                <script>
                    $(document).ready(function(){
                        // Toggle individual sections
                        $('.toggle-section').click(function(){
                            $(this).next('.content').slideToggle();
                            $(this).find('i').toggleClass('fa-chevron-up fa-chevron-down');
                        });
                        // Toggle all sections
                        $('.toggle-all').click(function(){
                            $('.all-filters .content').slideToggle();
                            $('.toggle-section i').toggleClass('fa-chevron-up fa-chevron-down');
                            $(this).find('i').toggleClass('fa-chevron-up fa-chevron-down');
                        });
                    });
                </script>
            </div>
            <!-- Shop Sidebar End -->
            <!-- Shop Product Start -->
            <div class="col-lg-9 col-md-12">
                <div class="row pb-3">
                    <div class="col-12 pb-1">
                        <div class="d-flex align-items-center justify-content-between mb-4">
                            <form action="<?php echo e(route('filtro')); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <div class="input-group">
                                    <input type="text" class="form-control" placeholder="Buscar por nombre" name="buscar">
                                    <div class="input-group-append">
                                        <button type="submit" class="input-group-text bg-transparent color-principal-color border-0">
                                            <i class="fa fa-search"></i>
                                        </button>
                                    </div>
                                </div>
                            </form>
                            <div class="dropdown ml-4">
                                <button class="btn border dropdown-toggle" type="button" id="triggerId" data-toggle="dropdown" aria-haspopup="true"
                                        aria-expanded="false">
                                            Ordenar por
                                        </button>
                                <div class="dropdown-menu dropdown-menu-right" aria-labelledby="triggerId">
                                    <form id="filterForm" action="<?php echo e(route('filtro')); ?>">
                                        <input type="hidden" name="period" id="periodInput" value="<?php echo e(request()->input('period')); ?>">
                                    </form>
                                    <a class="dropdown-item" href="#" onclick="submitForm('asc')">A - Z</a>
                                    <a class="dropdown-item" href="#" onclick="submitForm('desc')">Z - A</a>
                                    <a class="dropdown-item" href="#" onclick="submitForm('mayorPrecio')">Mayor precio</a>
                                    <a class="dropdown-item" href="#" onclick="submitForm('menorPrecio')">Menor precio</a>
                                </div>
                                <script>
                                    function submitForm(value) {
                                        document.getElementById('periodInput').value = value;
                                        document.getElementById('filterForm').submit();
                                    }
                                </script>
                            </div>
                        </div>
                    </div>
                    <?php $__currentLoopData = $productos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $producto): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-lg-3 col-md-3 col-sm-4 col-6 pb-1">
                        <div class="card product-item border-0 mb-4">
                            <div class="card-header product-img position-relative overflow-hidden bg-transparent border p-0">
                                <?php if($producto->imagen_principal_prod): ?>
                                    <a href="<?php echo e(route('detalle.producto', $producto->codigo_prod)); ?>"><img class="img-fluid w-100"  src="<?php echo e(asset('assets/img/productos/' . $producto->imagen_principal_prod)); ?>" alt="producto" ></a>
                                <?php else: ?>
                                    <a href="<?php echo e(route('detalle.producto', $producto->codigo_prod)); ?>"><img class="img-fluid w-100"  src="<?php echo asset('assets/img/products.png'); ?>" alt="producto" ></a>
                                <?php endif; ?>
                            </div>
                            <div class="card-body border-left border-right text-center p-0 pt-4 pb-3">
                                <h6 class="text-truncate mb-3"><?php echo e($producto->nombre_prod); ?></h6>
                                <div class="d-flex justify-content-center">
                                    <h6> <?php echo e("$" . number_format($producto->venta_prod, 2)); ?></h6>
                                </div>
                            </div>
                            <div class="card-footer  justify-content-between bg-light border text-center">
                                <a href="<?php echo e(route('detalle.producto',$producto->codigo_prod)); ?>" class="btn btn-sm text-dark p-0"><i class="fas fa-eye color-principal-color mr-1"></i>Ver Detalles</a>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <style>
                    .pagination-container {
                        display: flex;
                        justify-content: center;
                        padding: 1rem 0;
                    }
                    .pagination {
                        display: flex;
                        list-style: none;
                        padding: 0;
                        margin: 0;
                    }
                    .page-item {
                        margin: 0 3px;
                    }
                    .page-link {
                        display: flex;
                        justify-content: center;
                        align-items: center;
                        width: 40px;
                        height: 40px;
                        border-radius: 50%;
                        text-decoration: none;
                        color: #333;
                        font-weight: 600;
                        transition: all 0.2s ease;
                    }
                    .page-link:hover {
                        background-color: #f0f0f0;
                    }
                    .current-page {
                        color: white;
                        background-color: #0d6efd;
                        border-radius: 50%;
                        display: flex;
                        justify-content: center;
                        align-items: center;
                        width: 40px;
                        height: 40px;
                        font-weight: 600;
                    }
                    .pagination-ellipsis {
                        display: flex;
                        align-items: center;
                        justify-content: center;
                        width: 40px;
                        height: 40px;
                    }
                    .pagination-arrow {
                        font-size: 1.2rem;
                    }
                </style>
                <div class="row">
                    <div class="col-md-12 col-12">
                        <nav aria-label="Page navigation" class="pagination-container">
                            <ul class="pagination bg-lightest-gray">
                                
                                <li class="page-item <?php echo e(($productos->currentPage() == 1) ? 'disabled' : ''); ?>">
                                    <a class="page-link pagination-arrow" href="<?php echo e($productos->previousPageUrl()); ?>" aria-label="Previous">
                                        <i class="fas fa-arrow-circle-left"></i>
                                    </a>
                                </li>
                                <?php
                                    $currentPage = $productos->currentPage();
                                    $lastPage = $productos->lastPage();
                                    $window = 2; // How many pages to show on each side of current page
                                ?>
                                
                                <?php if($currentPage > ($window + 2)): ?>
                                    <li class="page-item">
                                        <a class="page-link" href="<?php echo e($productos->url(1)); ?>">1</a>
                                    </li>
                                    <li class="page-item">
                                        <span class="pagination-ellipsis">...</span>
                                    </li>
                                <?php endif; ?>
                                
                                <?php for($i = max(1, $currentPage - $window); $i <= min($lastPage, $currentPage + $window); $i++): ?>
                                    <li class="page-item">
                                        <a class="page-link <?php echo e($productos->currentPage() == $i ? 'current-page' : ''); ?>"
                                            href="<?php echo e($productos->appends([
                                                'buscar' => $buscar,
                                                'categoria' => $categoriaSelecconado,
                                                'subcategoria' => $subcategoriaSelecconado,
                                                'marca' => $marcaSelecconado,
                                                'precio_min' => $precio_minSeleccionado,
                                                'precio_max' => $precio_maxSeleccionado
                                            ])->url($i)); ?>">
                                            <?php echo e($i); ?>

                                        </a>
                                    </li>
                                <?php endfor; ?>
                                
                                <?php if($currentPage < ($lastPage - $window - 1)): ?>
                                    <li class="page-item">
                                        <span class="pagination-ellipsis">...</span>
                                    </li>
                                    <li class="page-item">
                                        <a class="page-link" href="<?php echo e($productos->url($lastPage)); ?>"><?php echo e($lastPage); ?></a>
                                    </li>
                                <?php endif; ?>
                                
                                <li class="page-item <?php echo e(($productos->currentPage() == $lastPage) ? 'disabled' : ''); ?>">
                                    <a class="page-link pagination-arrow" href="<?php echo e($productos->nextPageUrl()); ?>" aria-label="Next">
                                        <i class="fas fa-arrow-circle-right"></i>
                                    </a>
                                </li>
                            </ul>
                        </nav>
                    </div>
                </div>
            </div>
            <!-- Shop Product End -->
        </div>
    </div>
    <!-- CONTENIDO FIN -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('tienda/layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\tiendablogauto\resources\views/tienda/tiendas.blade.php ENDPATH**/ ?>