<?php
$VerEditor = auth()->user()->can('Usuarios - Visor') || auth()->user()->can('Usuarios - Editor')
?>
<?php if($VerEditor): ?>

<?php $__env->startSection('tituloModulo', 'USUARIOS'); ?>
<?php $__env->startSection('contenido'); ?>
<div class="card">
    <div class="card-body">
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Usuarios - Editor')): ?>
        <button type="button" class="btn btn-success mt-3" data-bs-toggle="modal" data-bs-target="#crear">
            <i class="bx bxs-folder-plus"></i> Agregar usuario
        </button>
        <div class="modal fade" id="crear" tabindex="-1">
            <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Agregar usuario</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form action="<?php echo e(route('usuarios.store')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-6 col-12">
                                <label class="control-label is-required">Nombre</label>
                                <input class="form-control" type="text" name="name" required>
                            </div>
                            <div class="col-md-6 col-12">
                                <label class="control-label is-required">Email</label>
                                <input class="form-control" type="email" name="email" required>
                            </div>
                            <div class="col-md-6 col-12">
                                <label  for="password" class="control-label is-required">Contraseña</label>
                                <input id="password"  class="form-control" type="password" name="password"  required>
                            </div>
                            <div class="col-md-6 col-12">
                                <label for="password-confirm" class="control-label is-required">Confirmar contraseña</label>
                                <input id="password-confirm" type="password" class="form-control" name="password_confirmation" required autocomplete="new-password">
                            </div>
                            <div class="col-md-6 col-12">
                                <label class="control-label is-required">Roles</label>
                                <select class="form-select" name="role" id="role">
                                    <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($role->name); ?>"><?php echo e($role->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success"><i class="bx bx-save"></i> Guardar</button>
                        <button type="button" class="btn btn-danger" data-bs-dismiss="modal"><i class="bx  bxs-x-circle"></i> Cerrar</button>
                    </div>
                    </form>
                </div>
            </div>
        </div>
        <?php endif; ?>
        <div class="datatable-wrapper datatable-loading no-footer sortable searchable fixed-columns">
            <div class="datatable-container">
                <table class="table datatable datatable-table">
                    <thead>
                        <tr class="text">
                            <th data-sortable="true" scope="col">NOMBRE</th>
                            <th data-sortable="true" scope="col">EMAIL</th>
                            <th data-sortable="true" scope="col">ROL</th>
                            <th data-sortable="true" scope="col">ESTATUS</th>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Usuarios - Editor')): ?>
                            <th data-sortable="true" scope="col">ACCIÓN</th>
                            <?php endif; ?>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $datos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td data-title="NOMBRE"><?php echo e($item->name); ?></td>
                            <td data-title="EMAIL"><?php echo e($item->email); ?></td>

                            <td data-title="ROL">
                                <?php $__currentLoopData = $item->roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php echo e($role->name); ?>

                                    <?php if(!$loop->last): ?>
                                        ,
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </td>
                            <td data-title="ESTATUS">
                                <?php if($item->status == 'Activo'): ?>
                                    <span class="badge bg-success"><?php echo e($item->status); ?></span>
                                <?php endif; ?>
                                <?php if($item->status== 'Inactivo'): ?>
                                    <span class="badge bg-danger"><?php echo e($item->status); ?></span>
                                <?php endif; ?>
                            </td>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Usuarios - Editor')): ?>
                            <td data-title="ACCIÓN">
                                <div class="btn-group">
                                    <button type="button" class="btn btn-outline-primary dropdown-toggle btnTabla"
                                        data-bs-toggle="dropdown" aria-expanded="false">Acción <i
                                            class="mdi mdi-chevron-down"></i></button>
                                    <div class="dropdown-menu">
                                        <button type="button" class="btn btn-outline-success mt-2 dropdown-item" data-bs-toggle="modal" data-bs-target="#editar<?php echo e($item->id); ?>">
                                            <i class="bx bxs-edit"></i> Editar
                                        </button>
                                        <form action="<?php echo e(route('usuarios.activate', $item->id)); ?>" method="POST" enctype="multipart/form-data" class="form-activar">
                                            <?php echo csrf_field(); ?>
                                            <button class="dropdown-item"   type="submit" id="btn" >
                                                <i class="bx bx-check-circle"></i> Activar
                                            </button>
                                        </form>
                                        <form action="<?php echo e(route('usuarios.inactivate', $item->id)); ?>" method="POST" enctype="multipart/form-data" class="form-inactivar">
                                            <?php echo csrf_field(); ?>
                                            <button class="dropdown-item"   type="submit" id="btn" >
                                                <i class="bx bx-x-circle"></i> Inactivar
                                            </button>
                                        </form>
                                        <form action="<?php echo e(route('usuarios.delete', $item->id)); ?>" method="POST" enctype="multipart/form-data" class="form-delete">
                                            <?php echo csrf_field(); ?>
                                            <button class="dropdown-item"   type="submit" id="btn" >
                                                <i class="bx  bxs-trash"></i> Eliminar
                                            </button>
                                        </form>
                                    </div>
                                </div>
                            </td>
                            <?php endif; ?>
                        </tr>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Usuarios - Editor')): ?>
                        <div class="modal fade" id="editar<?php echo e($item->id); ?>" tabindex="-1">
                            <div class="modal-dialog modal-lg">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title">Editar usuario</h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                    </div>
                                    <form action="<?php echo e(route('usuarios.update',  $item->id)); ?>" method="POST">
                                        <?php echo csrf_field(); ?>
                                    <div class="modal-body">
                                        <div class="row">
                                            <div class="col-md-6 col-12">
                                                <label class="control-label is-required">Nombre</label>
                                                <input class="form-control" value="<?php echo e($item->name); ?>" type="text" name="name" required>
                                            </div>
                                            <div class="col-md-6 col-12">
                                                <label class="control-label is-required">Email</label>
                                                <input class="form-control" value="<?php echo e($item->email); ?>" type="email" name="email" required>
                                            </div>
                                            <div class="col-md-6 col-12">
                                                <label  for="password" class="control-label is-required">Contraseña</label>
                                                <input id="password"  class="form-control" type="password" name="password">
                                            </div>
                                            <div class="col-md-6 col-12">
                                                <label for="password-confirm" class="control-label is-required">Confirmar contraseña</label>
                                                <input id="password-confirm" type="password" class="form-control" name="password_confirmation">
                                            </div>
                                            <div class="col-md-6 col-12">
                                                <label class="control-label is-required">Roles</label>
                                                <select class="form-select" name="role" id="role">
                                                    <?php $__currentLoopData = $item->roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($role->name); ?>"><?php echo e($role->name); ?></option>
                                                        <?php if(!$loop->last): ?>
                                                            ,
                                                        <?php endif; ?>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($role->name); ?>"><?php echo e($role->name); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="submit" class="btn btn-success"><i class="bx bx-save"></i> Actualizar</button>
                                        <button type="button" class="btn btn-danger" data-bs-dismiss="modal"><i class="bx  bxs-x-circle"></i> Cerrar</button>
                                    </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                        <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
            <div class="datatable-bottom">
                <nav class="datatable-pagination">
                    <ul class="datatable-pagination-list"></ul>
                </nav>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php endif; ?>


<?php echo $__env->make('layouts/app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\tienda\resources\views/usuarios/index.blade.php ENDPATH**/ ?>