<?php
$VerEditor = auth()->user()->can('Calificaciones - Visor') || auth()->user()->can('Calificaciones - Editor')
?>
<?php if($VerEditor): ?>

<?php $__env->startSection('tituloModulo', 'CALIFICACIONES'); ?>
<?php $__env->startSection('contenido'); ?>
<div class="card">
    <div class="card-body">
        <div class="datatable-wrapper datatable-loading no-footer sortable searchable fixed-columns">
            <div class="datatable-container">
                <table class="table datatable datatable-table">
                    <thead>
                        <tr class="text">
                            <th data-sortable="true" scope="col">USUARIO</th>
                            <th data-sortable="true" scope="col">PRODUCTO</th>
                            <th data-sortable="true" scope="col">RESEÑA</th>
                            <th data-sortable="true" scope="col">CALIFICACIÓN</th>
                            <th data-sortable="true" scope="col">FECHA</th>
                            <th data-sortable="true" scope="col">ESTATUS</th>
                            <th data-sortable="true" scope="col">ACCIÓN</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $datos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td data-title="USUARIO"><?php echo e($item->name); ?></td>
                            <td data-title="PRODUCTO"><a href="<?php echo e(route('detalle.producto', $item->codigo_prod)); ?>"><?php echo e($item->nombre_prod); ?></a></td>
                            <td data-title="RESEÑA"><?php echo e($item->resena_calif); ?></td>
                            <td data-title="CALIFICACIÓN">
                            <?php
                            $filledStars = $item->calificacion_calif;
                            $emptyStars = 5 - $filledStars;
                            ?>
                            <?php for($i = 0; $i < $filledStars; $i++): ?>
                            <i class="fas fa-star" style="color: #EABE3F;"></i>
                            <?php endfor; ?>
                            <?php for($i = 0; $i < $emptyStars; $i++): ?>
                                <i class="far fa-star" style="color: #EABE3F;"></i>
                            <?php endfor; ?>
                            </td>
                            <td data-title="FECHA"><?php echo e(date("d/m/Y", strtotime($item->fecha_calif))); ?></td>
                            <td data-title="ESTATUS">
                                <?php if($item->estatus_calif == 'Aprobado'): ?>
                                    <span class="badge bg-success"><?php echo e($item->estatus_calif); ?></span>
                                <?php endif; ?>
                                <?php if($item->estatus_calif == 'Pendiente por aprobar'): ?>
                                    <span class="badge bg-warning"><?php echo e($item->estatus_calif); ?></span>
                                <?php endif; ?>
                            </td>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Calificaciones - Editor')): ?>
                            <td data-title="ACCIÓN">
                                <div class="btn-group">
                                    <button type="button" class="btn btn-outline-primary dropdown-toggle btnTabla"
                                        data-bs-toggle="dropdown" aria-expanded="false">Acción <i
                                            class="mdi mdi-chevron-down"></i></button>
                                    <div class="dropdown-menu">
                                        <form action="<?php echo e(route('calificaciones.aprobar', $item->codigo_calif)); ?>">
                                            <?php echo csrf_field(); ?>
                                            <button class="dropdown-item"   type="submit" id="btn" >
                                                <i class="bx bx-check-circle"></i> Aprobar
                                            </button>
                                        </form>
                                        <form action="<?php echo e(route('calificaciones.pendiente', $item->codigo_calif)); ?>">
                                            <?php echo csrf_field(); ?>
                                            <button class="dropdown-item"   type="submit" id="btn" >
                                                <i class="bx bx-x-circle"></i> Pendiente por aprobar
                                            </button>
                                        </form>
                                        <form action="<?php echo e(route('calificaciones.delete', $item->codigo_calif)); ?>" class="form-delete">
                                            <?php echo csrf_field(); ?>
                                            <button class="dropdown-item"   type="submit" id="btn" >
                                                <i class="bx  bxs-trash"></i> Eliminar
                                            </button>
                                        </form>
                                    </div>
                                </div>
                            </td>
                            <?php endif; ?>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
            <div class="datatable-bottom">
                <nav class="datatable-pagination">
                    <ul class="datatable-pagination-list"></ul>
                </nav>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php endif; ?>


<?php echo $__env->make('layouts/app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\keninails\resources\views/calificaciones/index.blade.php ENDPATH**/ ?>