<?php
$VerEditor = auth()->user()->can('Cupones - Visor') || auth()->user()->can('Cupones - Editor')
?>
<?php if($VerEditor): ?>

<?php $__env->startSection('tituloModulo', 'CUPONES'); ?>
<?php $__env->startSection('contenido'); ?>
<div class="card">
    <div class="card-body">
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Cupones - Editor')): ?>
        <button type="button" class="btn btn-success mt-3" data-bs-toggle="modal" data-bs-target="#crear">
            <i class="bx bxs-folder-plus"></i> Agregar cupón
        </button>
        <div class="modal fade" id="crear" tabindex="-1">
            <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Agregar cupón</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form action="<?php echo e(route('cupones.store')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-6 col-12">
                                <label class="control-label is-required">Fecha de inicio</label>
                                <input class="form-control" type="date" name="fecha_inicio" required>
                            </div>
                            <div class="col-md-6 col-12">
                                <label class="control-label is-required">Fecha de vencimiento</label>
                                <input class="form-control" type="date" name="fecha_fin" required>
                            </div>
                            <div class="col-md-6 col-12">
                                <label class="control-label is-required">Cantidad en % o $</label>
                                <input id="input-currency" class="form-control input-mask text-left importe"
                                data-inputmask="'alias': 'numeric', 'groupSeparator': ',', 'digits': 2, 'digitsOptional': false, 'prefix': '', 'placeholder': '0'"
                                name="cantidad"  required>
                            </div>
                            <div class="col-md-6 col-12">
                                <label class="control-label is-required">Tipo de cupón</label>
                                <select class="form-select" name="tipo" required>
                                    <option value="">Seleccione el tipo de cupón</option>
                                    <option value="Porcentaje">Descuento por porcentaje</option>
                                    <option value="Monetario">Descuento por moneda</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success"><i class="bx bx-save"></i> Guardar</button>
                        <button type="button" class="btn btn-danger" data-bs-dismiss="modal"><i class="bx  bxs-x-circle"></i> Cerrar</button>
                    </div>
                    </form>
                </div>
            </div>
        </div>
        <?php endif; ?>
        <div class="datatable-wrapper datatable-loading no-footer sortable searchable fixed-columns">
            <div class="datatable-container">
                <table class="table datatable datatable-table">
                    <thead>
                        <tr class="text">
                            <th data-sortable="true" scope="col">CÓDIGO</th>
                            <th data-sortable="true" scope="col">FECHA DE INICIO</th>
                            <th data-sortable="true" scope="col">FECHA DE VENCIMIENTO</th>
                            <th data-sortable="true" scope="col">DESCUENTO EN % O $</th>
                            <th data-sortable="true" scope="col">TIPO DE DESCUENTO</th>
                            <th data-sortable="true" scope="col">ESTATUS</th>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Cupones - Editor')): ?>
                            <th data-sortable="true" scope="col">ACCIÓN</th>
                            <?php endif; ?>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $datos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td data-title="CÓDIGO"><?php echo e($item->codigo_cupo); ?></td>
                            <td data-title="FECHA DE INICIO"><?php echo e(date("d/m/Y", strtotime($item->fecha_inicio_cupo))); ?></td>
                            <td data-title="FECHA DE VENCIMIENTO"><?php echo e(date("d/m/Y", strtotime($item->fecha_vencimiento_cupo))); ?></td>
                            <?php if($item->tipo_cupo == "Porcentaje"): ?>
                            <td data-title="DESCUENTO EN % O $"><?php echo e(number_format($item->descuento_cupo, 2) . "%"); ?></td>
                            <?php endif; ?>
                            <?php if($item->tipo_cupo == "Monetario"): ?>
                            <td data-title="DESCUENTO EN % O $"><?php echo e("$" . number_format($item->descuento_cupo, 2)); ?></td>
                            <?php endif; ?>
                            <td data-title="TIPO DE DESCUENTO"><?php echo e($item->tipo_cupo); ?></td>
                            <td data-title="ESTATUS">
                                <?php if($item->estatus_cupo == 'Activo'): ?>
                                    <span class="badge bg-success"><?php echo e($item->estatus_cupo); ?></span>
                                <?php endif; ?>
                                <?php if($item->estatus_cupo == 'Inactivo'): ?>
                                    <span class="badge bg-danger"><?php echo e($item->estatus_cupo); ?></span>
                                <?php endif; ?>
                            </td>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Cupones - Editor')): ?>
                            <td data-title="ACCIÓN">
                                <div class="btn-group">
                                    <button type="button" class="btn btn-outline-primary dropdown-toggle btnTabla"
                                        data-bs-toggle="dropdown" aria-expanded="false">Acción <i
                                            class="mdi mdi-chevron-down"></i></button>
                                    <div class="dropdown-menu">
                                        <button type="button" class="btn btn-outline-success mt-2 dropdown-item" data-bs-toggle="modal" data-bs-target="#editar<?php echo e($item->codigo_cupo); ?>">
                                            <i class="bx bxs-edit"></i> Editar
                                        </button>
                                        <form action="<?php echo e(route('cupones.activate', $item->codigo_cupo)); ?>" method="POST" enctype="multipart/form-data" class="form-activar">
                                            <?php echo csrf_field(); ?>
                                            <button class="dropdown-item"   type="submit" id="btn" >
                                                <i class="bx bx-check-circle"></i> Activar
                                            </button>
                                        </form>
                                        <form action="<?php echo e(route('cupones.inactivate', $item->codigo_cupo)); ?>" method="POST" enctype="multipart/form-data" class="form-inactivar">
                                            <?php echo csrf_field(); ?>
                                            <button class="dropdown-item"   type="submit" id="btn" >
                                                <i class="bx bx-x-circle"></i> Inactivar
                                            </button>
                                        </form>
                                        <form action="<?php echo e(route('cupones.delete', $item->codigo_cupo)); ?>" method="POST" enctype="multipart/form-data" class="form-delete">
                                            <?php echo csrf_field(); ?>
                                            <button class="dropdown-item"   type="submit" id="btn" >
                                                <i class="bx  bxs-trash"></i> Eliminar
                                            </button>
                                        </form>
                                    </div>
                                </div>
                            </td>
                            <?php endif; ?>
                        </tr>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Cupones - Editor')): ?>
                        <div class="modal fade" id="editar<?php echo e($item->codigo_cupo); ?>" tabindex="-1">
                            <div class="modal-dialog modal-lg">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title">Editar marca</h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                    </div>
                                    <form action="<?php echo e(route('cupones.update',  $item->codigo_cupo)); ?>" method="POST">
                                        <?php echo csrf_field(); ?>
                                    <div class="modal-body">
                                        <div class="row">
                                            <div class="col-md-6 col-12">
                                                <label class="control-label is-required">Fecha de inicio</label>
                                                <input class="form-control" type="date" name="fecha_inicio" value="<?php echo e($item->fecha_inicio_cupo); ?>" required>
                                            </div>
                                            <div class="col-md-6 col-12">
                                                <label class="control-label is-required">Fecha de vencimiento</label>
                                                <input class="form-control" type="date" name="fecha_fin" value="<?php echo e($item->fecha_vencimiento_cupo); ?>" required>
                                            </div>
                                            <div class="col-md-6 col-12">
                                                <label class="control-label is-required">Cantidad en % o $</label>
                                                <input id="input-currency" class="form-control input-mask text-left importe"
                                                data-inputmask="'alias': 'numeric', 'groupSeparator': ',', 'digits': 2, 'digitsOptional': false, 'prefix': '', 'placeholder': '0'"
                                                name="cantidad" value="<?php echo e($item->descuento_cupo); ?>"  required>
                                            </div>
                                            <div class="col-md-6 col-12">
                                                <label class="control-label is-required">Tipo de cupón</label>
                                                <select class="form-select" name="tipo" required>
                                                    <?php if($item->tipo_cupo == "Porcentaje"): ?>
                                                    <option value="<?php echo e($item->tipo_cupo); ?>">Descuento por porcentaje</option>
                                                    <?php endif; ?>
                                                    <?php if($item->tipo_cupo == "Monetario"): ?>
                                                    <option value="<?php echo e($item->tipo_cupo); ?>">Descuento por moneda</option>
                                                    <?php endif; ?>
                                                    <option value="Porcentaje">Descuento por porcentaje</option>
                                                    <option value="Monetario">Descuento por moneda</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="submit" class="btn btn-success"><i class="bx bx-save"></i> Actualizar</button>
                                        <button type="button" class="btn btn-danger" data-bs-dismiss="modal"><i class="bx  bxs-x-circle"></i> Cerrar</button>
                                    </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                        <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
            <div class="datatable-bottom">
                <nav class="datatable-pagination">
                    <ul class="datatable-pagination-list"></ul>
                </nav>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php endif; ?>


<?php echo $__env->make('layouts/app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\keninails\resources\views/cupones/index.blade.php ENDPATH**/ ?>