<?php
$VerEditor = auth()->user()->can('Datos del usuario - Visor') || auth()->user()->can('Datos del usuario - Editor')
?>
<?php if($VerEditor): ?>

<?php $__env->startSection('tituloModulo', 'DATOS DEL CLIENTE'); ?>
<?php $__env->startSection('contenido'); ?>
<form action="<?php echo e(route('clientes.update', $datos->codigo_clie)); ?>" method="POST" enctype="multipart/form-data">
    <div class="card">
        <div class="card-body">
                <?php echo csrf_field(); ?>
                <?php echo method_field('put'); ?>
            <h5 class="card-title">Datos generales</h5>
            <div class="row">
                <div class="col-md-12 col-12">
                    <label class="control-label is-required">Nombre</label>
                    <input class="form-control" type="text" name="nombre" value="<?php echo e($datos->nombre_cliente); ?>"  required>
                </div>
                <div class="col-md-6 col-12">
                    <label class="control-label">Correo Electrónico</label>
                    <input class="form-control" type="email" name="email" value="<?php echo e($datos->email); ?>"  disabled>
                </div>
                <div class="col-md-6 col-12">
                    <label class="control-label">Teléfono</label>
                    <input class="form-control" type="text" name="telefono" value="<?php echo e($datos->telefono_clie); ?>">
                </div>
                <div class="col-md-12 col-12">
                    <label class="control-label">Dirección</label>
                    <input class="form-control" type="text" name="direccion" value="<?php echo e($datos->direccion_clie); ?>" >
                </div>
                <div class="col-md-12 col-12">
                    <label class="control-label">Rerencia del domicilio</label>
                    <textarea class="form-control" name="referencia"><?php echo e($datos->referencia_clie); ?></textarea>
                </div>
                <div class="col-md-6 col-12">
                    <label class="control-label">País</label>
                    <input class="form-control" type="text" name="pais" value="<?php echo e($datos->pais_clie); ?>" >
                </div>
                <div class="col-md-6 col-12">
                    <label class="control-label">Ciudad</label>
                    <input class="form-control" type="text" name="ciudad" value="<?php echo e($datos->ciudad_clie); ?>" >
                </div>
                <div class="col-md-6 col-12">
                    <label class="control-label">Estado</label>
                    <select class="form-select" aria-label="Default select example" name="estado">
                        <?php if($datos->estado_clie): ?>
                        <option value="<?php echo e($datos->estado_clie); ?>"><?php echo e($datos->nombreEstado); ?></option>
                        <?php else: ?>
                        <option value="">Seleccione un estado de la republica</option>
                        <?php endif; ?>
                        <?php $__currentLoopData = $estadosRepublica; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $estadoRepublica): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($estadoRepublica->id); ?>"><?php echo e($estadoRepublica->nombre_edo); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-md-6 col-12">
                    <label class="control-label">Código Postal</label>
                    <input class="form-control" type="text" name="cp" value="<?php echo e($datos->codigo_postal_clie); ?>">
                </div>
            </div>
        </div>
    </div>
    <div class="card">
        <div class="card-body">
            <h5 class="card-title">Datos Facturación</h5>
            <div class="row">
                <div class="col-md-12 col-12">
                    <label class="control-label">Nombre o Nombre de la empresa</label>
                    <input class="form-control" type="text" name="nombre_fact" value="<?php echo e($datos->nombre_facturacion_clie); ?>" >
                </div>
                <div class="col-md-6 col-12">
                    <label class="control-label"><?php echo e("Registro Federal Contribuyentes (RFC)"); ?></label>
                    <input class="form-control" type="text" name="rfc_fact" id="rfc_fact" value="<?php echo e($datos->rfc_facturacion_clie); ?>">
                </div>
                <div class="col-md-6 col-12">
                    <label class="control-label">Código Postal</label>
                    <input class="form-control" type="text" name="cp_fact"value="<?php echo e($datos->codigo_postal_facturacion_clie); ?>"|>
                </div>
                <div class="col-md-6 col-12">
                    <label class="control-label">Uso de Factura</label>
                    <select class="form-select" aria-label="Default select example" name="uso_fact">
                    <?php if($datos->uso_facturacion_clie): ?>
                        <option value="<?php echo e($datos->uso_facturacion_clie); ?>"><?php echo e($datos->uso_facturacion_clie); ?></option>
                    <?php else: ?>
                    <option value="">Seleccione el uso del CFDI 4.0</option>
                    <?php endif; ?>
                    <option value="(G01) Adquisición de mercancías">(G01) Adquisición de mercancías</option>
                    <option value="(G02) Devoluciones, descuentos o bonificaciones">(G02) Devoluciones, descuentos o bonificaciones</option>
                    <option value="(G03) Gastos en general">(G03) Gastos en general</option>
                    <option value="(I01) Construcciones">(I01) Construcciones</option>
                    <option value="(I02) Mobiliario y equipo de oficina por inversiones">(I02) Mobiliario y equipo de oficina por inversiones</option>
                    <option value="(I03) Equipo de transporte">(I03) Equipo de transporte</option>
                    <option value="(I04) Equipo de cómputo y accesorios">(I04) Equipo de cómputo y accesorios</option>
                    <option value="(I05) Dados, troqueles, moldes, matrices y herramental">(I05) Dados, troqueles, moldes, matrices y herramental</option>
                    <option value="(I06) Comunicaciones telefónicas">(I06) Comunicaciones telefónicas</option>
                    <option value="(I07) Comunicaciones satelitales">(I07) Comunicaciones satelitales</option>
                    <option value="(I08) Otra maquinaria y equipo">(I08) Otra maquinaria y equipo</option>
                    <option value="(D01) Honorarios médicos, dentales y gastos hospitalarios.">(D01) Honorarios médicos, dentales y gastos hospitalarios.</option>
                    <option value="(D02) Gastos médicos por incapacidad o discapacidad">(D02) Gastos médicos por incapacidad o discapacidad</option>
                    <option value="(D03) Gastos funerales.">(D03) Gastos funerales.</option>
                    <option value="(D04) Donativos">(D04) Donativos</option>
                    <option value="(D05) Intereses reales efectivamente pagados por créditos hipotecarios (casa habitación).">(D05) Intereses reales efectivamente pagados por créditos hipotecarios (casa habitación).</option>
                    <option value="(D06) Aportaciones voluntarias al SAR.">(D06) Aportaciones voluntarias al SAR.</option>
                    <option value="(D07) Primas por seguros de gastos médicos.">(D07) Primas por seguros de gastos médicos.</option>
                    <option value="(D08) Gastos de transportación escolar obligatoria.">(D08) Gastos de transportación escolar obligatoria.</option>
                    <option value="(D09) Depósitos en cuentas para el ahorro, primas que tengan como base planes de pensiones.">(D09) Depósitos en cuentas para el ahorro, primas que tengan como base planes de pensiones.</option>
                    <option value="(D10) Pagos por servicios educativos (colegiaturas)">(D10) Pagos por servicios educativos (colegiaturas)</option>
                    <option value="(CP01) Pagos">(CP01) Pagos</option>
                    <option value="(CN01) Nómina">(CN01) Nómina</option>
                    <option value="(S01) Sin Efectos Fiscales">(S01) Sin Efectos Fiscales</option>
                    </select>
                </div>
                <div class="col-md-6 col-12">
                    <label class="control-label">Régimen Fiscal</label>
                    <select class="form-select" aria-label="Default select example" name="regimen_fact">
                        <?php if($datos->regimen_facturacion_clie): ?>
                            <option value="<?php echo e($datos->regimen_facturacion_clie); ?>"><?php echo e($datos->regimen_facturacion_clie); ?></option>
                        <?php else: ?>
                        <option value="">Seleccione el Régimen Fiscal</option>
                        <?php endif; ?>
                        <option value="(601) General de Ley Personas Morales">(601) General de Ley Personas Morales</option>
                        <option value="(603) Personas Morales con Fines no Lucrativos">(603) Personas Morales con Fines no Lucrativos</option>
                        <option value="(605) Sueldos y Salarios e Ingresos Asimilados a Salarios">(605) Sueldos y Salarios e Ingresos Asimilados a Salarios</option>
                        <option value="(606) Arrendamiento">(606) Arrendamiento</option>
                        <option value="(607) Régimen de Enajenación o Adquisición de Bienes">(607) Régimen de Enajenación o Adquisición de Bienes</option>
                        <option value="(608) Demás ingresos">(608) Demás ingresos</option>
                        <option value="(609) Consolidación">(609) Consolidación</option>
                        <option value="(610) Residentes en el Extranjero sin Establecimiento Permanente en México">(610) Residentes en el Extranjero sin Establecimiento Permanente en México</option>
                        <option value="(611) Ingresos por Dividendos (socios y accionistas)">(611) Ingresos por Dividendos (socios y accionistas)</option>
                        <option value="(612) Personas Físicas con Actividades Empresariales y Profesionales">(612) Personas Físicas con Actividades Empresariales y Profesionales</option>
                        <option value="(614) Ingresos por intereses">(614) Ingresos por intereses</option>
                        <option value="(615) Régimen de los ingresos por obtención de premios">(615) Régimen de los ingresos por obtención de premios</option>
                        <option value="(616) Sin obligaciones fiscales">(616) Sin obligaciones fiscales</option>
                        <option value="(620) Sociedades Cooperativas de Producción que optan por diferir sus ingresos">(620) Sociedades Cooperativas de Producción que optan por diferir sus ingresos</option>
                        <option value="(621) Incorporación Fiscal">(621) Incorporación Fiscal</option>
                        <option value="(622) Actividades Agrícolas, Ganaderas, Silvícolas y Pesqueras">(622) Actividades Agrícolas, Ganaderas, Silvícolas y Pesqueras</option>
                        <option value="(623) Opcional para Grupos de Sociedades">(623) Opcional para Grupos de Sociedades</option>
                        <option value="(624) Coordinados">(624) Coordinados</option>
                        <option value="(625) Régimen de las Actividades Empresariales con ingresos a través de Plataformas Tecnológicas">(625) Régimen de las Actividades Empresariales con ingresos a través de Plataformas Tecnológicas</option>
                        <option value="(626) Régimen Simplificado de Confianza">(626) Régimen Simplificado de Confianza</option>
                        <option value="(628) Hidrocarburos">(628) Hidrocarburos</option>
                        <option value="(629) De los Regímenes Fiscales Preferentes y de las Empresas Multinacionales">(629) De los Regímenes Fiscales Preferentes y de las Empresas Multinacionales</option>
                        <option value="(630) Enajenación de acciones en bolsa de valores">(630) Enajenación de acciones en bolsa de valores</option>
                    </select>
                </div>
                <div class="col-md-6 col-12">
                    <label class="control-label">Constancia Fiscal - Archivo PDF</label>
                    <input class="form-control" type="file" name="archivo">
                </div>
                <?php if($datos->constancia_facturacion_clie): ?>
                <div class="col-md-6 col-12">
                    <a href="<?php echo e(route('clientes.descargar.documento', $datos->codigo_clie )); ?>" class="btn btn-outline-primary mt-4" style="width: 100%" ><i class="bx bxs-cloud-download"></i> Descargar Constancia Fiscal</a>
                </div>
                <?php endif; ?>
            </div>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Datos del usuario - Editor')): ?>
            <button type="submit" class="btn btn-outline-success mt-2"><i class="bx bx-save"></i> Guardar</button>
            <?php endif; ?>
        </div>
    </div>
</form>
<?php $__env->stopSection(); ?>
<?php endif; ?>

<?php echo $__env->make('layouts/app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\keninails\resources\views/clientes/datos.blade.php ENDPATH**/ ?>