<?php
$VerEditor = auth()->user()->can('Roles - Visor') || auth()->user()->can('Roles - Editor')
?>
<?php if($VerEditor): ?>

<?php $__env->startSection('tituloModulo', 'ROLES'); ?>
<?php $__env->startSection('contenido'); ?>
<div class="card">
    <div class="card-body">
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Roles - Editor')): ?>
        <button type="button" class="btn btn-success mt-3" data-bs-toggle="modal" data-bs-target="#crear">
            <i class="bx bxs-folder-plus"></i> Agregar Rol
        </button>
        <div class="modal fade" id="crear" tabindex="-1">
            <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Agregar Rol</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form action="<?php echo e(route('roles.store')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-12 col-12">
                                <label class="control-label is-required">Nombre</label>
                                <input class="form-control" type="text" name="name" required>
                                <label for="permissions">Permisos:</label>
                                <select name="permissions[]" id="permissions"  class="form-control" multiple>
                                    <?php $__currentLoopData = $permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($permission->name); ?>"><?php echo e($permission->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success"><i class="bx bx-save"></i> Guardar</button>
                        <button type="button" class="btn btn-danger" data-bs-dismiss="modal"><i class="bx  bxs-x-circle"></i> Cerrar</button>
                    </div>
                    </form>
                </div>
            </div>
        </div>
        <?php endif; ?>
        <h5 class="card-title">Roles y sus Permisos</h5>
            <ul>
            <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li><?php echo e($role->name); ?>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Roles - Editor')): ?>
                    <a data-bs-toggle="modal" data-bs-target="#editar<?php echo e($role->id); ?>"><i class="bx bxs-edit"></i><strong>Editar</strong></a>
                    <?php endif; ?>
                </li>
            <ul>
                <?php $__currentLoopData = $role->permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($permission->name); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Roles - Editor')): ?>
                <div class="modal fade" id="editar<?php echo e($role->id); ?>" tabindex="-1">
                    <div class="modal-dialog modal-lg">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title">Editar Rol</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <form action="<?php echo e(route('roles.update',  $role->id)); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('put'); ?>
                            <div class="modal-body">
                                <div class="row">
                                    <div class="col-md-12 col-12">
                                        <label class="control-label is-required">Nombre</label>
                                        <input class="form-control" type="text" name="name" value="<?php echo e($role->name); ?>" disabled>
                                        <label for="permissions">Nuevos Permisos:</label>
                                        <label>Permisos:</label>
                                        <?php $__currentLoopData = $permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div>
                                                <input type="checkbox" name="permissions[]" value="<?php echo e($permission->name); ?>" <?php echo e($role->permissions->contains($permission) ? 'checked' : ''); ?>>
                                                <label><?php echo e($permission->name); ?></label>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="submit" class="btn btn-success"><i class="bx bx-save"></i> Actualizar</button>
                                <button type="button" class="btn btn-danger" data-bs-dismiss="modal"><i class="bx  bxs-x-circle"></i> Cerrar</button>
                            </div>
                            </form>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php endif; ?>

<?php echo $__env->make('layouts/app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\tienda\resources\views/roles/index.blade.php ENDPATH**/ ?>