<?php
$VerEditor = auth()->user()->can('Ventas - Visor') || auth()->user()->can('Ventas - Editor')
?>
<?php if($VerEditor): ?>

<?php $__env->startSection('tituloModulo', 'VENTAS'); ?>
<?php $__env->startSection('contenido'); ?>
<?php if($errors->any()): ?>
    <div class="alert alert-danger">
        <ul>
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li><?php echo e($error); ?></li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
    </div>
<?php endif; ?>
<?php if($mensaje = Session::get('success')): ?>
    <div class="alert alert-success" role="alert"><?php echo e($mensaje); ?></div>
<?php endif; ?>
<?php if($mensaje = Session::get('danger')): ?>
    <div class="alert alert-danger" role="alert"><?php echo e($mensaje); ?></div>
<?php endif; ?>
<div class="card">
    <div class="card-body">
        <div class="datatable-wrapper datatable-loading no-footer sortable searchable fixed-columns">
            <div class="datatable-container">
                <table class="table datatable datatable-table">
                    <thead>
                        <tr class="text">
                            <th data-sortable="true" scope="col"><?php echo e("NO. COMPRA"); ?></th>
                            <th data-sortable="true" scope="col">ID PROVEEDOR PAGO</th>
                            <th data-sortable="true" scope="col">NOMBRE</th>
                            <th data-sortable="true" scope="col">TELÉFONO</th>
                            <th data-sortable="true" scope="col">CORREO ELECTRÓNICO</th>
                            <th data-sortable="true" scope="col">SUBTOTAL</th>
                            <th data-sortable="true" scope="col">DESCUENTO</th>
                            <th data-sortable="true" scope="col">TOTAL</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $datos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td data-title="<?php echo e("NO. COMPRA"); ?>"><?php echo e($item->numero_pago); ?></td>
                            <td data-title="ID PROVEEDOR PAGO"><?php echo e($item->payment_id_paco); ?></td>
                            <td data-title="NOMBRE"><?php echo e($item->nombre_comp); ?></td>
                            <td data-title="TELÉFONO"><?php echo e($item->telefono_comp); ?></td>
                            <td data-title="CORREO ELECTRÓNICO"><?php echo e($item->email_comp); ?></td>
                            <td data-title="SUBTOTAL"><?php echo e("$" . number_format($item->sub_total_comp, 2)); ?></td>
                            <td data-title="DESCUENTO"><?php echo e("$" . number_format($item->descuento_comp, 2)); ?></td>
                            <td data-title="TOTAL"><?php echo e("$" . number_format($item->total_comp, 2)); ?></td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
            <div class="datatable-bottom">
                <nav class="datatable-pagination">
                    <ul class="datatable-pagination-list"></ul>
                </nav>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php endif; ?>

<?php echo $__env->make('layouts/app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\keninails\resources\views/ventas/index.blade.php ENDPATH**/ ?>