<?php $__env->startSection('contenido'); ?>
<style>
    .color-circle {
        display: inline-block;
        width: 30px;
        height: 30px;
        border-radius: 50%;
        border: 5px solid #ccc;
        cursor: pointer;
        transition: border-color 0.3s; /* Transición suave para el cambio de color del borde */
    }
    /* Estilo para el borde dorado cuando el radio button está seleccionado */
    .custom-control-input:checked ~ .color-circle {
        border-color: gold;
    }

    .hidden {
        display: none;
    }
    .unstyled {
        padding-left: 0;
        list-style: none;
        margin-bottom: 0;
    }
    .checkout .icon-block i {
        position: absolute;
        top: 8px;
        right: 16px;
        font-size: 24px;
        color: #7A7F85;
    }
        /* Chrome, Safari, Edge, Opera */
        input[type="number"]::-webkit-outer-spin-button,
        input[type="number"]::-webkit-inner-spin-button {
            -webkit-appearance: none;
            margin: 0;
        }
        /* Firefox */
        input[type="number"] {
            -moz-appearance: textfield;
        }
</style>
<script src="https://www.paypal.com/sdk/js?client-id=<?php echo e(env('IDCLIENTPAYPAL')); ?>&components=buttons&currency=MXN"></script>

<!-- Navbar Start -->
    <div class="container-fluid">
        <div class="row border-top px-xl-5">
            <div class="col-lg-3 d-none d-lg-block">
                <a class="btn shadow-none d-flex align-items-center justify-content-between color-principal text-white w-100" data-toggle="collapse" href="#navbar-vertical" style="height: 65px; margin-top: -1px; padding: 0 30px; background-color: #ffffff;">
                    <h6 class="m-0">Categorías</h6>
                    <i class="fa fa-angle-down text-dark"></i>
                </a>
                <nav class="collapse position-absolute navbar navbar-vertical navbar-light align-items-start p-0 border border-top-0 border-bottom-0 bg-light" id="navbar-vertical" style="width: calc(100% - 30px); z-index: 1;">
                    <div class="navbar-nav w-100 overflow-hidden" style="height: 410px">
                        <div class="nav-item dropdown">
                            <a href="#" class="nav-link" data-toggle="dropdown">Subcategoría <i class="fa fa-angle-down float-right mt-1"></i></a>
                            <div class="dropdown-menu position-absolute bg-secondary border-0 rounded-0 w-100 m-0">
                                <?php $__currentLoopData = $subcategorias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subcategoria): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <form action="<?php echo e(route('filtro')); ?>" method="POST" id="form-<?php echo e($subcategoria->codigo_prsu); ?>">
                                    <?php echo csrf_field(); ?>
                                    <a href="#" class="dropdown-item" onclick="document.getElementById('form-<?php echo e($subcategoria->codigo_prsu); ?>').submit(); return false;">
                                    <?php echo e($subcategoria->nombre_prsu); ?></a>
                                    <input type="hidden" name="subcategoria[]" value="<?php echo e($subcategoria->codigo_prsu); ?>">
                                </form>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                        <?php $__currentLoopData = $categorias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $categoria): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <form action="<?php echo e(route('filtro')); ?>" method="POST" id="form-<?php echo e($categoria->codigo_prca); ?>">
                            <?php echo csrf_field(); ?>
                            <a href="#" class="nav-item nav-link" onclick="document.getElementById('form-<?php echo e($categoria->codigo_prca); ?>').submit(); return false;">
                            <?php echo e($categoria->nombre_prca); ?></a>
                            <input type="hidden" name="categoria[]" value="<?php echo e($categoria->codigo_prca); ?>">
                        </form>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </nav>
            </div>
            <div class="col-lg-9">
                <nav class="navbar navbar-expand-lg bg-light navbar-light py-3 py-lg-0 px-0">
                    <a href="" class="text-decoration-none d-block d-lg-none">
                        <h1 class="m-0 display-5 font-weight-semi-bold"><span class="color-principal-color font-weight-bold border px-3 mr-1">K</span><span class="nombre_empresa"></span></h1>
                    </a>
                    <button type="button" class="navbar-toggler" data-toggle="collapse" data-target="#navbarCollapse">
                        <span class="navbar-toggler-icon"></span>
                    </button>
                    <div class="collapse navbar-collapse justify-content-between" id="navbarCollapse">
                        <div class="navbar-nav mr-auto py-0">
                            <a href="<?php echo e(route('index')); ?>" class="nav-item nav-link active">Inicio</a>
                            <a href="<?php echo e(route('catalogo')); ?>" class="nav-item nav-link">Tienda</a>
                            <a href="<?php echo e(route('carrito')); ?>" class="nav-item nav-link">Carrito</a>
                            <a href="<?php echo e(route('contacto')); ?>" class="nav-item nav-link">Contacto</a>
                        </div>
                        <div class="navbar-nav ml-auto py-0">
                            <?php if(Auth::check() && $usuario): ?>
                            <a href="<?php echo e(route('home')); ?>" class="nav-item nav-link">Panel de control</a>
                            <?php else: ?>
                            <a href="<?php echo e(route('login')); ?>" class="nav-item nav-link">Acceso</a>
                            <a href="<?php echo e(route('register')); ?>" class="nav-item nav-link">Registro</a>
                            <?php endif; ?>
                        </div>
                    </div>
                </nav>
            </div>
        </div>
    </div>
    <!--HEADER INICIO -->
    <div class="container-fluid">
        <div class="d-flex flex-column align-items-center justify-content-center" style="min-height: 50px">
            <h1 class="font-weight-semi-bold text-uppercase">Proceso de compra</h1>
            <div class="d-inline-flex">
                <p class="m-0"><a href="<?php echo e(route('index')); ?>" class="color-principal-color">Inicio</a></p>
                <p class="m-0 px-2">-</p>
                <p class="m-0">Catálogo</p>
            </div>
        </div>
    </div>
    <!--HEADER FIN -->
    <!-- CONTENIDO INICIO-->
    <div class="container-fluid pt-5">
        <div class="row px-xl-5">
            <div class="col-lg-8">
                <div class="mb-4">
                    <h4 class="font-weight-semi-bold mb-4">DATOS DEL COMPRADOR</h4>
                    <div class="row">
                        <div class="col-md-12 form-group">
                            <label>Nombre completo</label>
                            <input class="form-control" type="text" name="nombre" id="nombre"  <?php if(Auth::check() && $usuario): ?> value="<?php echo e($usuario->nombre_cliente); ?>" <?php endif; ?> >
                        </div>
                        <div class="col-md-6 col-12 form-group">
                            <label>Correo electrónico</label>
                            <input type="email" class="form-control mb-24" name="email" id="email" <?php if(Auth::check() && $usuario): ?> value="<?php echo e($usuario->email); ?>" <?php endif; ?>>
                        </div>
                        <div class="col-md-6 col-12 form-group">
                            <label>Télefono</label>
                            <input type="number" class="form-control mb-24" name="telefono" id="telefono" <?php if(Auth::check() && $usuario): ?> value="<?php echo e($usuario->telefono_clie); ?>" <?php endif; ?>>
                        </div>
                        <div class="col-md-12 col-12 form-group">
                            <label>Dirección</label>
                            <input type="text" class="form-control mb-24" name="direccion" id="direccion" <?php if(Auth::check() && $usuario): ?> value="<?php echo e($usuario->direccion_clie); ?>" <?php endif; ?>>
                        </div>
                        <div class="col-md-12 col-12 form-group">
                            <label>Referencia</label>
                            <textarea  name="referencia" id="referencia" class="form-control check-form  mb-24" required><?php if(Auth::check() && $usuario): ?>  <?php echo e($usuario->referencia_clie); ?> <?php endif; ?></textarea>
                        </div>
                        <div class="col-md-6 col-12 form-group">
                            <label>País</label>
                            <input type="text" class="form-control mb-24" name="pais" id="pais" <?php if(Auth::check() && $usuario): ?> value="<?php echo e($usuario->pais_clie); ?>" <?php endif; ?>>
                        </div>
                        <div class="col-md-6 col-12 form-group">
                            <label>Ciudad</label>
                            <input type="text" class="form-control mb-24" name="ciudad" id="ciudad" <?php if(Auth::check() && $usuario): ?> value="<?php echo e($usuario->ciudad_clie); ?>" <?php endif; ?>>
                        </div>
                        <div class="col-md-6 form-group">
                            <label>Estado</label>
                            <select class="form-control mb-24" aria-label="Default select example" name="estado" id="estado">
                                <?php if(Auth::check() && $usuario): ?>
                                <?php if($usuario->estado_clie): ?>
                                <option value="<?php echo e($usuario->estado_clie); ?>"><?php echo e($usuario->nombreEstado); ?></option>
                                <?php else: ?>
                                <option value="">Estado</option>
                                <?php endif; ?>
                                <?php else: ?>
                                <option value="">Estado</option>
                                <?php endif; ?>
                                <?php $__currentLoopData = $estadosRepublica; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $estadoRepublica): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($estadoRepublica->id); ?>"><?php echo e($estadoRepublica->nombre_edo); ?>

                                </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="col-md-6 col-12 form-group">
                            <label>Código Postal</label>
                            <input type="number" class="form-control check-form mb-24 cps" name="cp" id="cp" <?php if(Auth::check() && $usuario): ?> value="<?php echo e($usuario->codigo_postal_clie); ?>" <?php endif; ?>>
                        </div>
                        <div class="col-sm-12 col-md-12 col-12  form-group">
                            <?php if(Auth::check() && $usuario): ?>
                            <div class="custom-control custom-checkbox">
                                <input type="checkbox" class="custom-control-input addDirecciones" id="addDirecciones">
                                <label class="custom-control-label" for="addDirecciones">¿Deseas cambiar la dirección de entrega?</label>
                            </div>
                            <?php if($errors->any()): ?>
                            <div class="alert alert-danger">
                                <ul>
                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><?php echo e($error); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                            <?php endif; ?>
                            <?php if($mensaje = Session::get('success')): ?>
                            <div class="alert alert-success" role="alert"><?php echo e($mensaje); ?></div>
                            <?php endif; ?>
                            <?php if($mensaje = Session::get('danger')): ?>
                            <div class="alert alert-danger" role="alert"><?php echo e($mensaje); ?></div>
                            <?php endif; ?>
                            <!-- Button trigger modal -->
                            <div id="direccionDiv" class="hidden">
                                <button type="button" class="btn btn-success" data-toggle="modal" data-target="#exampleModal">Agregar dirección<i class="bx bxs-folder-plus"></i> </button>
                                <div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="crear" aria-hidden="true">
                                    <div class="modal-dialog">
                                        <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="exampleModalLabel">Agregar nueva dirección</h5>
                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">&times;</span>
                                            </button>
                                        </div>
                                        <form action="<?php echo e(route('direcciones.store')); ?>" method="POST">
                                            <?php echo csrf_field(); ?>
                                            <div class="modal-body">
                                                <div class="row p-3">
                                                    <div class="col-md-12 col-12">
                                                        <label class="control-label is-required">Dirección</label>
                                                        <input class="form-control check-form mb-24" type="text"
                                                            name="direccion" required>
                                                    </div>
                                                    <div class="col-md-12 col-12">
                                                        <label class="control-label is-required">Referencia</label>
                                                        <textarea name="referencia" class="form-control check-form mb-24" required></textarea>
                                                    </div>
                                                    <div class="col-md-6 col-12">
                                                        <label class="control-label is-required">Estado</label>
                                                        <select class="form-control check-form mb-24"
                                                            aria-label="Default select example" name="estado"
                                                            required>
                                                            <option value="">Seleccione un Estado</option>
                                                            <?php $__currentLoopData = $estadosRepublica; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $estadoRepublica): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($estadoRepublica->id); ?>"><?php echo e($estadoRepublica->nombre_edo); ?></option>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </select>
                                                    </div>
                                                    <div class="col-md-6 col-12">
                                                        <label class="control-label is-required">Ciudad</label>
                                                        <input class="form-control check-form mb-24" type="text"
                                                            name="ciudad" required>
                                                    </div>
                                                    <div class="col-md-6 col-12">
                                                        <label class="control-label is-required">Código
                                                            Postal</label>
                                                        <input class="form-control check-form mb-24" type="text"
                                                            name="cp" required>
                                                    </div>
                                                    <div class="col-md-6 col-12">
                                                        <label class="control-label is-required">País</label>
                                                        <input class="form-control check-form mb-24" type="text"
                                                            name="pais" required>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="submit" class="btn btn-success"><i
                                                        class="bx bx-save"></i> Guardar</button>
                                                <button type="button" class="btn btn-danger"
                                                    data-bs-dismiss="modal"><i class="bx  bxs-x-circle"></i>
                                                    Cerrar</button>
                                            </div>
                                        </form>
                                        </div>
                                    </div>
                                </div>
                                <?php $__currentLoopData = $direcciones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $direccion): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="payment-options bg-white br-1 box-shadow-3">
                                    <input type="radio"  id="<?php echo e($direccion->codigo_dire); ?>" class="nuevaDireccion" name="nuevaDireccion" value="<?php echo e($direccion->codigo_dire); ?>">
                                    <label for="<?php echo e($direccion->codigo_dire); ?>" class="light-black fw-600 light-black h6 mb-0"><?php echo e($direccion->direccion_dire); ?>, <?php echo e($direccion->ciudad_dire); ?>, <?php echo e($direccion->nombre_edo); ?>, <?php echo e($direccion->codigo_postal_dire); ?>

                                    </label>
                                </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                            <?php endif; ?>
                        </div>
                        <div class="col-md-12 form-group">
                            <div class="custom-control custom-checkbox">
                                <input type="checkbox" class="custom-control-input" id="shipto" class="requieredFact">
                                <label class="custom-control-label" for="shipto"  data-toggle="collapse" data-target="#shipping-address">Requiero Factura</label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="collapse mb-4" id="shipping-address">
                    <h4 class="font-weight-semi-bold mb-4">Datos de facturación</h4>
                    <div class="row">
                        <div class="col-md-12 col-12 form-group">
                            <label>Nombre o Nombre de la empresa</label>
                            <input type="text" class="form-control check-form mb-24" name="nombre_fact" id="nombre_fact" <?php if(Auth::check() && $usuario): ?> value="<?php echo e($usuario->nombre_facturacion_clie); ?>" <?php endif; ?>>
                        </div>
                        <div class="col-md-6 col-12 form-group">
                            <label>RFC</label>
                            <input type="text" class="form-control check-form mb-24" name="rfc_fact" id="rfc_fact" <?php if(Auth::check() && $usuario): ?> value="<?php echo e($usuario->rfc_facturacion_clie); ?>" <?php endif; ?>>
                        </div>
                        <div class="col-md-6 col-12 form-group">
                            <label>Código Postal</label>
                            <input type="text" class="form-control check-form mb-24" name="cp_fact" id="cp_fact" <?php if(Auth::check() && $usuario): ?> value="<?php echo e($usuario->codigo_postal_facturacion_clie); ?>" <?php endif; ?>>
                        </div>
                        <div class="col-md-6 col-12 form-group">
                            <label>Uso de CDFI 4.0</label>
                            <select class="form-control check-form mb-24" aria-label="Default select example" name="uso_fact" id="uso_fact">
                                <?php if(Auth::check() && $usuario): ?>
                                    <?php if($usuario->uso_facturacion_clie): ?>
                                    <option value="<?php echo e($usuario->uso_facturacion_clie); ?>"><?php echo e($usuario->uso_facturacion_clie); ?></option>
                                    <?php else: ?>
                                    <option value="">Seleccione el uso del CFDI 4.0</option>
                                    <?php endif; ?>
                                <?php else: ?>
                                <option value="">Seleccione el uso del CFDI 4.0</option>
                                <?php endif; ?>
                                <option value="(G01) Adquisición de mercancías">(G01) Adquisición de
                                    mercancías</option>
                                <option value="(G02) Devoluciones, descuentos o bonificaciones">(G02)
                                    Devoluciones, descuentos o bonificaciones</option>
                                <option value="(G03) Gastos en general">(G03) Gastos en general</option>
                                <option value="(I01) Construcciones">(I01) Construcciones</option>
                                <option value="(I02) Mobiliario y equipo de oficina por inversiones">(I02)
                                    Mobiliario y equipo de oficina por inversiones</option>
                                <option value="(I03) Equipo de transporte">(I03) Equipo de transporte
                                </option>
                                <option value="(I04) Equipo de cómputo y accesorios">(I04) Equipo de cómputo
                                    y accesorios</option>
                                <option value="(I05) Dados, troqueles, moldes, matrices y herramental">(I05)
                                    Dados, troqueles, moldes, matrices y herramental</option>
                                <option value="(I06) Comunicaciones telefónicas">(I06) Comunicaciones
                                    telefónicas</option>
                                <option value="(I07) Comunicaciones satelitales">(I07) Comunicaciones
                                    satelitales</option>
                                <option value="(I08) Otra maquinaria y equipo">(I08) Otra maquinaria y
                                    equipo</option>
                                <option value="(D01) Honorarios médicos, dentales y gastos hospitalarios.">
                                    (D01) Honorarios médicos, dentales y gastos hospitalarios.</option>
                                <option value="(D02) Gastos médicos por incapacidad o discapacidad">(D02)
                                    Gastos médicos por incapacidad o discapacidad</option>
                                <option value="(D03) Gastos funerales.">(D03) Gastos funerales.</option>
                                <option value="(D04) Donativos">(D04) Donativos</option>
                                <option
                                    value="(D05) Intereses reales efectivamente pagados por créditos hipotecarios (casa habitación).">
                                    (D05) Intereses reales efectivamente pagados por créditos hipotecarios
                                    (casa habitación).</option>
                                <option value="(D06) Aportaciones voluntarias al SAR.">(D06) Aportaciones
                                    voluntarias al SAR.</option>
                                <option value="(D07) Primas por seguros de gastos médicos.">(D07) Primas por
                                    seguros de gastos médicos.</option>
                                <option value="(D08) Gastos de transportación escolar obligatoria.">(D08)
                                    Gastos de transportación escolar obligatoria.</option>
                                <option
                                    value="(D09) Depósitos en cuentas para el ahorro, primas que tengan como base planes de pensiones.">
                                    (D09) Depósitos en cuentas para el ahorro, primas que tengan como base
                                    planes de pensiones.</option>
                                <option value="(D10) Pagos por servicios educativos (colegiaturas)">(D10)
                                    Pagos por servicios educativos (colegiaturas)</option>
                                <option value="(CP01) Pagos">(CP01) Pagos</option>
                                <option value="(CN01) Nómina">(CN01) Nómina</option>
                                <option value="(S01) Sin Efectos Fiscales">(S01) Sin Efectos Fiscales
                                </option>
                            </select>
                        </div>
                        <div class="col-md-6 col-12 form-group">
                            <label>Régimen Fiscal</label>
                            <select class="form-control check-form mb-24" aria-label="Default select example"name="regime_fact" id="regime_fact">
                                <?php if(Auth::check() && $usuario): ?>
                                <?php if($usuario->regimen_facturacion_clie): ?>
                                <option value="<?php echo e($usuario->regimen_facturacion_clie); ?>"><?php echo e($usuario->regimen_facturacion_clie); ?></option>
                                <?php else: ?>
                                <option value="">Seleccione el Régimen Fiscal</option>
                                <?php endif; ?>
                                <?php else: ?>
                                <option value="">Seleccione el Régimen Fiscal</option>
                                <?php endif; ?>
                                <option value="(601) General de Ley Personas Morales">(601) General de Ley
                                    Personas Morales</option>
                                <option value="(603) Personas Morales con Fines no Lucrativos">(603)
                                    Personas Morales con Fines no Lucrativos</option>
                                <option value="(605) Sueldos y Salarios e Ingresos Asimilados a Salarios">
                                    (605) Sueldos y Salarios e Ingresos Asimilados a Salarios</option>
                                <option value="(606) Arrendamiento">(606) Arrendamiento</option>
                                <option value="(607) Régimen de Enajenación o Adquisición de Bienes">(607)
                                    Régimen de Enajenación o Adquisición de Bienes</option>
                                <option value="(608) Demás ingresos">(608) Demás ingresos</option>
                                <option value="(609) Consolidación">(609) Consolidación</option>
                                <option
                                    value="(610) Residentes en el Extranjero sin Establecimiento Permanente en México">
                                    (610) Residentes en el Extranjero sin Establecimiento Permanente en
                                    México</option>
                                <option value="(611) Ingresos por Dividendos (socios y accionistas)">(611)
                                    Ingresos por Dividendos (socios y accionistas)</option>
                                <option
                                    value="(612) Personas Físicas con Actividades Empresariales y Profesionales">
                                    (612) Personas Físicas con Actividades Empresariales y Profesionales
                                </option>
                                <option value="(614) Ingresos por intereses">(614) Ingresos por intereses
                                </option>
                                <option value="(615) Régimen de los ingresos por obtención de premios">(615)
                                    Régimen de los ingresos por obtención de premios</option>
                                <option value="(616) Sin obligaciones fiscales">(616) Sin obligaciones
                                    fiscales</option>
                                <option
                                    value="(620) Sociedades Cooperativas de Producción que optan por diferir sus ingresos">
                                    (620) Sociedades Cooperativas de Producción que optan por diferir sus
                                    ingresos</option>
                                <option value="(621) Incorporación Fiscal">(621) Incorporación Fiscal
                                </option>
                                <option
                                    value="(622) Actividades Agrícolas, Ganaderas, Silvícolas y Pesqueras">
                                    (622) Actividades Agrícolas, Ganaderas, Silvícolas y Pesqueras</option>
                                <option value="(623) Opcional para Grupos de Sociedades">(623) Opcional para
                                    Grupos de Sociedades</option>
                                <option value="(624) Coordinados">(624) Coordinados</option>
                                <option
                                    value="(625) Régimen de las Actividades Empresariales con ingresos a través de Plataformas Tecnológicas">
                                    (625) Régimen de las Actividades Empresariales con ingresos a través de
                                    Plataformas Tecnológicas</option>
                                <option value="(626) Régimen Simplificado de Confianza">(626) Régimen
                                    Simplificado de Confianza</option>
                                <option value="(628) Hidrocarburos">(628) Hidrocarburos</option>
                                <option
                                    value="(629) De los Regímenes Fiscales Preferentes y de las Empresas Multinacionales">
                                    (629) De los Regímenes Fiscales Preferentes y de las Empresas
                                    Multinacionales</option>
                                <option value="(630) Enajenación de acciones en bolsa de valores">(630)
                                    Enajenación de acciones en bolsa de valores</option>
                            </select>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-4">
                <div class="card border-secondary mb-5">
                    <div class="card-header color-principal border-0" >
                        <h4 class="font-weight-semi-bold m-0" style="color: #ffffff;">ORDEN DE COMPRA</h4>
                    </div>
                    <div class="card-body">
                        <h5 class="font-weight-medium mb-3">Productos</h5>
                        <?php if($cart): ?>
                        <?php $__currentLoopData = $cart; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="d-flex justify-content-between">
                            <p><?php echo e("(" . $item['cantidad'] . ")"); ?>  <?php echo e($item['nombreProduct']); ?> </p>
                            <p><?php echo e("$" . number_format($item['total'], 2)); ?></p>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                        <hr class="mt-0">
                        <div class="d-flex justify-content-between mb-3 pt-1">
                            <?php
                            $totalCost = 0; // Inicializamos el total en 0
                            if ($cart) {
                            foreach ($cart as $item) {
                            // Sumamos el costo del producto actual al total
                            $totalCost += $item['costo'] * $item['cantidad'];
                            }
                            }
                            ?>
                            <h6 class="font-weight-medium">Subtotal</h6>
                            <h6 class="font-weight-medium"><?php echo e("$" . number_format($totalCost, 2)); ?></h6>
                        </div>
                        <div class="d-flex justify-content-between" >
                            <p id="labelEnvio" style="display: none"><strong>Seleccione en envío</strong></p>
                        </div>
                        <div class="d-flex justify-content-between">
                            <?php if($empresas->envio_config == 'Por Paqueteria'): ?>
                            <p class="font-weight-medium" id="dtosEnvioRadio"></p>
                            <?php endif; ?>
                        </div>
                        <div class="d-flex justify-content-between">
                            <h6 class="font-weight-medium">Envío</h6>
                            <?php if($empresas->envio_config == 'Costo Fijo'): ?>
                            <h6 class="font-weight-medium"><?php echo e("$" . number_format($empresas->costo_envio_config,2)); ?></h6>
                            <?php elseif($empresas->envio_config == 'Por Paqueteria'): ?>
                            <h6 class="font-weight-medium dtosEnvioTot">$0.00</h6>
                            <?php endif; ?>
                        </div>
                        <div class="d-flex justify-content-between">
                            <h6 class="font-weight-medium">Descuento</h6>
                            <?php if($datosCupon): ?>
                                <?php if($datosCupon->tipo_cupo == 'Porcentaje'): ?>
                                <h6 class="font-weight-medium"><?php echo e("- $" . number_format($totalCost * ($datosCupon->descuento_cupo / 100 ), 2)); ?></h6>
                                <?php endif; ?>
                                <?php if($datosCupon->tipo_cupo == 'Monetario'): ?>
                                <h6 class="font-weight-medium"><?php echo e(" - $" . number_format( $datosCupon->descuento_cupo,2)); ?></h6>
                                <?php endif; ?>
                                <?php else: ?>
                                <h6 class="font-weight-medium"><?php echo e("$" . number_format("0",2)); ?></h6>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="card-footer border-secondary bg-transparent">
                        <div class="d-flex justify-content-between mt-2">
                            <h5 class="font-weight-bold">Total</h5>
                            <?php if($empresas->envio_config == 'Costo Fijo'): ?>
                                <?php if($datosCupon): ?>
                                <h5 class="font-weight-bold"><?php echo e("$" . number_format(($totalCost - ($totalCost * ($datosCupon->descuento_cupo / 100)) +
                                    $empresas->costo_envio_config), 2)); ?></h5>
                                <?php else: ?>
                                <h5 class="font-weight-bold"><?php echo e("$" . number_format(($totalCost + $empresas->costo_envio_config), 2)); ?></h5>
                                <?php endif; ?>
                            <?php elseif($empresas->envio_config == 'Por Paqueteria'): ?>
                            <h5 class="font-weight-bold montoTotal"><?php echo e("$" . number_format($totalCost, 2)); ?></h5>
                            <?php endif; ?>
                        </div>
                        <input type="checkbox" id="term-cdn" class="termcdn">
                                <label for="term-cdn" class="gray">Acepto los <a href="<?php echo e(route('terminos.condiciones')); ?>" style="color: #00B79A">Términos y Condiciones</a></label>
                    </div>
                </div>
                <div class="card border-secondary mb-5">
                    <div class="card-header border-0 color-principal">
                        <h4 class="font-weight-semi-bold m-0" style="color: #ffffff;">Método de pago</h4>
                    </div>
                    <div class="card-body">
                        <div class="form-group">
                            <div class="custom-control custom-radio">
                                <?php if($cart): ?>
                                <div id="wallet_container" class="btnMP"></div>
                                <div id="paypal-button-container" class="btnPay"></div>
                                <?php else: ?>
                                <div class="alert alert-danger">Carrito Vacio</div>
                                <?php endif; ?>
                            </div>
                            <?php if($empresas->mercado_pago_config && $cart): ?>
                            <div class="custom-control custom-radio">
                                <input type="radio" id="checkout-btn-mercadoPago" name="payment"  class="checkout paymentMP">
                                <label for="checkout-btn-mercadoPago" class="light-black fw-600 light-black h6 mb-0 ">
                                    <img alt="" src="<?php echo asset('assets/store/img/iconoMercadopago.png'); ?>"
                                        width="30px"> Mercado Pago
                                </label>
                            </div>
                            <?php endif; ?>
                            <?php if($empresas->paypal_config && $cart): ?>
                            <div class="custom-control custom-radio">
                                <input type="radio" id="checkout-btn-paypal" name="payment"  class="checkout paymentPA">
                                <label for="checkout-btn-paypal" class="light-black fw-600 light-black h6 mb-0">
                                    <img alt="" src="<?php echo asset('assets/store/img/paypalv2.png'); ?>"
                                        width="30px"> Paypal
                                </label>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- CONTENIDO FIN -->
    <script src="https://sdk.mercadopago.com/js/v2"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        function ejecutarPay(Preference){
            window.paypal.Buttons({
                createOrder: function(data, actions) {
                    // Lógica para crear el pedido
                    return actions.order.create({
                        purchase_units: [{
                            amount: {
                                value: Preference.total_comp,
                                currency_code: 'MXN',
                            }
                        }]
                    });
                },
                onApprove: function(data, actions) {
                    // Lógica para aprobar el pago
                    return actions.order.capture().then(function(details) {
                        window.location.href = '<?php echo e(Request::root()); ?>/paypal/pago/' + details.status + '/' + Preference.codigo_comp + '/' + details.id;
                    }).catch(function(error) {
                        // Manejar el error
                        Swal.fire({
                            icon: "error",
                            title: "Oops...",
                            text: "¡Hubo un error al procesar el pago!",
                        });
                    });
                }
            }).render('#paypal-button-container');
        }
    </script>
    <script>
        var rootUrl = "<?php echo e(url('/')); ?>";
        var token = "<?php echo e(csrf_token()); ?>";
        var tipoEnvio = "<?php echo e($empresas->envio_config); ?>";
        var dtsEnv = "";
        var codigoServicio = "";
        <?php if($empresas->mercado_pago_config): ?>
        const MERCADOPAGO_PUBLIC_KEY = '<?php echo e(env('MERCADOPAGO_PUBLIC_KEY')); ?>';
        $('.paymentMP').on('change', function() {
            if (this.checked) { $('.btnMP').show(); } else { $('.btnMP').hide(); }
            if (this.checked) { $('.btnPay').hide(); } else { $('.btnPay').show(); }
        });
        <?php endif; ?>
        <?php if($empresas->paypal_config): ?>
        $('.paymentPA').on('change', function() {
            if (this.checked) { $('.btnMP').hide(); } else { $('.btnMP').show(); }
            if (this.checked) { $('.btnPay').show(); } else { $('.btnPay').hide(); }
        });
        <?php endif; ?>
        <?php if($empresas->envio_config == 'Por Paqueteria'): ?>
        const codigoPostal = document.getElementById('cp');
        $(document).ready(function() {
            const codigoPostal = document.getElementById('cp');
            // Función para manejar el evento change
            function handleCpsChange() {
                var cps = $(this).val();
                var regex = /^\d{5}$/;
                if (!cps) {
                    Swal.fire({
                        icon: "error",
                        title: "Oops...",
                        text: "¡Código postal no encontrado!",
                    });
                    return;
                }
                if (regex.test(cps)) {
                    $.ajax({
                        url: '<?php echo e(Request::root()); ?>/api/skydropx/' + cps,
                        method: 'GET',
                        success: function(response) {
                            const radioContainer = document.getElementById('dtosEnvioRadio');
                            const labelEnvio = document.getElementById('labelEnvio');
                            // Vaciar el contenedor antes de añadir nuevos botones de radio
                            labelEnvio.style.display = 'block';
                            radioContainer.innerHTML = '';
                            // Aquí se asume que 'response' es el array de opciones de envío
                            response.forEach(option => {
                                const proveedor = option.provider;
                                const servicio = option.service_level_name;
                                const diasEntrega = option.days;
                                const costo = option.total_pricing;
                                const dtosEnvio = `Paqueteria ${proveedor} ${servicio} con ${diasEntrega} días de entrega y costo de ${costo}`;
                                const costoEnvio = `${costo}`;
                                // Crear un nuevo elemento de radio y su etiqueta
                                const radio = document.createElement('input');
                                radio.type = 'radio';
                                radio.name = 'dtosEnvio';
                                radio.id = 'dtosEnvio';
                                radio.value = costo;
                                radio.classList.add('form-check-input');
                                // Añadir un evento change al radio
                                radio.addEventListener('change', function() {
                                    if (this.checked) {
                                        codigoServicio = option.service_level_code;
                                        var envc = parseFloat(this.value);
                                        var nuevoCostoEnvio = envc.toLocaleString('es-MX', { style: 'currency', currency: 'MXN' });
                                        $('.dtosEnvioTot').text(nuevoCostoEnvio);
                                        var total = 0;
                                        var totalCosto = "<?php echo e($totalCost); ?>";
                                        var descuento = 0;
                                        <?php if($datosCupon): ?>
                                            <?php if($datosCupon->tipo_cupo == 'Porcentaje'): ?>
                                                descuento = totalCosto * ("<?php echo e($datosCupon->descuento_cupo); ?>" / 100);
                                            <?php endif; ?>
                                            <?php if($datosCupon->tipo_cupo == 'Monetario'): ?>
                                                descuento = "<?php echo e($datosCupon->descuento_cupo); ?>";
                                            <?php endif; ?>
                                        <?php endif; ?>
                                        total = (parseFloat(totalCosto) + parseFloat(envc)) - parseFloat(descuento);
                                        dtsEnv = envc;
                                        var nuevototal = total.toLocaleString('es-MX', { style: 'currency', currency: 'MXN' });
                                        $('.montoTotal').text(nuevototal);
                                    }
                                });
                                const label = document.createElement('label');
                                label.classList.add('form-check-label');
                                // Añadir el radio al principio de la etiqueta
                                label.appendChild(radio);
                                label.appendChild(document.createTextNode(' ' + dtosEnvio));
                                // Añadir la etiqueta al contenedor
                                radioContainer.appendChild(label);
                                radioContainer.appendChild(document.createElement('br'));
                            });
                        },
                        error: function(xhr, status, error) {
                            Swal.fire({
                                icon: "error",
                                title: "Oops...",
                                text: "¡Código postal no válido!",
                            });
                        }
                    });
                } else {
                    Swal.fire({
                        icon: "error",
                        title: "Oops...",
                        text: "¡El código postal debe tener 5 dígitos!",
                    });
                    return;
                }
            }
            // Asignar el evento change a .cps
            $(".cps").change(handleCpsChange);
            // Disparar el evento change si el campo de código postal ya tiene un valor válido
            if (codigoPostal.value && /^\d{5}$/.test(codigoPostal.value)) { $(codigoPostal).trigger('change'); }
            $('.addDirecciones').on('change', function() {
                if (!$(this).is(':checked')) {
                    $('.nuevaDireccion').prop('checked', false);
                    const codigoPostal = document.getElementById('cp');
                    $(".cps").change(handleCpsChange);
                    // Disparar el evento change si el campo de código postal ya tiene un valor válido
                    if (codigoPostal && codigoPostal.value && /^\d{5}$/.test(codigoPostal.value)) {
                        $(codigoPostal).trigger('change');
                    } else {
                        Swal.fire({
                            icon: "error",
                            title: "Oops...",
                            text: "¡Código postal no encontrado!",
                        });
                        const radioContainer = document.getElementById('dtosEnvioRadio');
                        const labelEnvio = document.getElementById('labelEnvio');
                        if (radioContainer && labelEnvio) {
                            radioContainer.style.display = 'none';
                            labelEnvio.style.display = 'none';
                        }
                    }
                }
            });
            $('.nuevaDireccion').on('change', function() {
                if ($(this).is(':checked')) {
                    var codigo = $(this).val();
                    $.ajax({
                        url: '<?php echo e(Request::root()); ?>/api/skydropx/addDireccion/' + codigo,
                        method: 'GET',
                        success: function(response) {
                            const radioContainer = document.getElementById('dtosEnvioRadio');
                            const labelEnvio = document.getElementById('labelEnvio');
                            // Vaciar el contenedor antes de añadir nuevos botones de radio
                            labelEnvio.style.display = 'block';
                            radioContainer.innerHTML = '';
                            // Aquí se asume que 'response' es el array de opciones de envío
                            response.forEach(option => {
                            const proveedor = option.provider;
                            const servicio = option.service_level_name;
                            codigoServicio = option.service_level_code;
                            const diasEntrega = option.days;
                            const costo = option.total_pricing;
                            var envc = parseFloat(costo);
                            var nuevoCostoEnvio = envc.toLocaleString('es-MX', { style: 'currency', currency: 'MXN' });
                            const dtosEnvio = `Paqueteria ${proveedor} ${servicio} con ${diasEntrega} días de entrega y costo de ${nuevoCostoEnvio}`;
                            const costoEnvio = `${costo}`;
                            // Crear un nuevo elemento de radio y su etiqueta
                            const radio = document.createElement('input');
                            radio.type = 'radio';
                            radio.name = 'dtosEnvio';
                            radio.id = 'dtosEnvio';
                            radio.value = costo;
                            radio.classList.add('form-check-input');
                            // Añadir un evento change al radio
                            radio.addEventListener('change', function() {
                                if (this.checked) {
                                    var envc = parseFloat(this.value);
                                    var nuevoCostoEnvio = envc.toLocaleString('es-MX', { style: 'currency', currency: 'MXN' });
                                    $('.dtosEnvioTot').text(nuevoCostoEnvio);
                                    var total = 0;
                                    var totalCosto = "<?php echo e($totalCost); ?>";
                                    var descuento = 0;
                                    <?php if($datosCupon): ?>
                                        <?php if($datosCupon->tipo_cupo == 'Porcentaje'): ?>
                                        descuento =  totalCosto * ("<?php echo e($datosCupon->descuento_cupo); ?>" / 100);
                                        <?php endif; ?>
                                        <?php if($datosCupon->tipo_cupo == 'Monetario'): ?>
                                        descuento = "<?php echo e($datosCupon->descuento_cupo); ?>";
                                        <?php endif; ?>
                                    <?php endif; ?>
                                    total = ( parseFloat(totalCosto) + parseFloat(envc) ) - parseFloat(descuento);
                                    dtsEnv = envc;
                                    var nuevototal = total.toLocaleString('es-MX', { style: 'currency', currency: 'MXN' });
                                    $('.montoTotal').text(nuevototal);
                                }
                            });
                                const label = document.createElement('label');
                                label.classList.add('form-check-label');
                                // Añadir el radio al principio de la etiqueta
                                label.appendChild(radio);
                                label.appendChild(document.createTextNode(' ' + dtosEnvio));
                                // Añadir la etiqueta al contenedor
                                radioContainer.appendChild(label);
                                radioContainer.appendChild(document.createElement('br'));
                                });
                            },
                            error: function(xhr, status, error) {
                                Swal.fire({
                                    icon: "error",
                                    title: "Oops...",
                                    text: "¡Código postal no valido!",
                                });
                            }
                        });
                }
            });
        });

        <?php else: ?>
        var dtsEnv = "<?php echo e($empresas->costo_envio_config); ?>";
        <?php endif; ?>
    </script>
    <script src="<?php echo asset('assets/store/js/mp.js'); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('tienda/layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\keninails\resources\views/tienda/procesarCompra.blade.php ENDPATH**/ ?>