<?php
$VerEditor = auth()->user()->can('Productos / Categorías - Visor') || auth()->user()->can('Productos / Categorías - Editor')
?>
<?php if($VerEditor): ?>

<?php $__env->startSection('tituloModulo', 'CATEGORÍAS'); ?>
<?php $__env->startSection('contenido'); ?>
<div class="card">
    <div class="card-body">
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Productos / Categorías - Editor')): ?>
        <button type="button" class="btn btn-success mt-3" data-bs-toggle="modal" data-bs-target="#crear">
            <i class="bx bxs-folder-plus"></i> Agregar categoría
        </button>
        <div class="modal fade" id="crear" tabindex="-1">
            <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Agregar categoría</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form action="<?php echo e(route('categorias.store')); ?>" method="POST" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <label class="control-label is-required">Nombre</label>
                        <input class="form-control" type="text" name="nombre" required>
                        <label class="control-label">Imagen en tienda</label>
                        <input class="form-control" type="file" name="imagen" required>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success"><i class="bx bx-save"></i> Guardar</button>
                        <button type="button" class="btn btn-danger" data-bs-dismiss="modal"><i class="bx  bxs-x-circle"></i> Cerrar</button>
                    </div>
                    </form>
                </div>
            </div>
        </div>
        <?php endif; ?>
        <div class="datatable-wrapper datatable-loading no-footer sortable searchable fixed-columns">
            <div class="datatable-container">
                <table class="table datatable datatable-table">
                    <thead>
                        <tr class="text">
                            <th data-sortable="true" scope="col">IMAGEN</th>
                            <th data-sortable="true" scope="col">NOMBRE</th>
                            <th data-sortable="true" scope="col">ESTATUS</th>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Productos / Categorías - Editor')): ?>
                            <th data-sortable="true" scope="col">ACCIÓN</th>
                            <?php endif; ?>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $datos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td data-title="IMAGEN">
                                <?php if($item->imagen_prca): ?>
                                <img class="img-fluid" src="<?php echo asset('assets/img/categorias/' . $item->imagen_prca ); ?>" alt="" style="width: 50px;">
                                <?php else: ?>
                                <img class="img-fluid" src="<?php echo asset('assets/img/sinimagen.png' ); ?>" alt="" style="width: 50px;">
                                <?php endif; ?>
                            </td>
                            <td data-title="NOMBRE"><?php echo e($item->nombre_prca); ?></td>
                            <td data-title="ESTATUS">
                                <?php if($item->estatus_prca == 'Activo'): ?>
                                    <span class="badge bg-success"><?php echo e($item->estatus_prca); ?></span>
                                <?php endif; ?>
                                <?php if($item->estatus_prca == 'Inactivo'): ?>
                                    <span class="badge bg-danger"><?php echo e($item->estatus_prca); ?></span>
                                <?php endif; ?>
                            </td>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Productos / Categorías - Editor')): ?>
                            <td data-title="ACCIÓN">
                                <div class="btn-group">
                                    <button type="button" class="btn btn-outline-primary dropdown-toggle btnTabla"
                                        data-bs-toggle="dropdown" aria-expanded="false">Acción <i
                                            class="mdi mdi-chevron-down"></i></button>
                                    <div class="dropdown-menu">
                                        <button type="button" class="btn btn-outline-success mt-2 dropdown-item" data-bs-toggle="modal" data-bs-target="#editar<?php echo e($item->codigo_prca); ?>">
                                            <i class="bx bxs-edit"></i> Editar
                                        </button>
                                        <form action="<?php echo e(route('categorias.activate', $item->codigo_prca)); ?>" method="POST" enctype="multipart/form-data" class="form-activar">
                                            <?php echo csrf_field(); ?>
                                            <button class="dropdown-item"   type="submit" id="btn" >
                                                <i class="bx bx-check-circle"></i> Activar
                                            </button>
                                        </form>
                                        <form action="<?php echo e(route('categorias.inactivate', $item->codigo_prca)); ?>" method="POST" enctype="multipart/form-data" class="form-inactivar">
                                            <?php echo csrf_field(); ?>
                                            <button class="dropdown-item"   type="submit" id="btn" >
                                                <i class="bx bx-x-circle"></i> Inactivar
                                            </button>
                                        </form>
                                        <form action="<?php echo e(route('categorias.delete', $item->codigo_prca)); ?>" method="POST" enctype="multipart/form-data" class="form-delete">
                                            <?php echo csrf_field(); ?>
                                            <button class="dropdown-item"   type="submit" id="btn" >
                                                <i class="bx  bxs-trash"></i> Eliminar
                                            </button>
                                        </form>
                                    </div>
                                </div>
                            </td>
                            <?php endif; ?>
                        </tr>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Productos / Categorías - Editor')): ?>
                        <div class="modal fade" id="editar<?php echo e($item->codigo_prca); ?>" tabindex="-1">
                            <div class="modal-dialog modal-lg">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title">Editar categoría</h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                    </div>
                                    <form action="<?php echo e(route('categorias.update',  $item->codigo_prca)); ?>" method="POST" enctype="multipart/form-data">
                                        <?php echo csrf_field(); ?>
                                    <div class="modal-body">
                                        <div class="row">
                                            <div class="col-md-12 col-12 text-center">
                                                <?php if($item->imagen_prca): ?>
                                                <img class="img-fluid" src="<?php echo asset('assets/img/categorias/' . $item->imagen_prca ); ?>" alt="" style="width: 250px;">
                                                <?php else: ?>
                                                <img class="img-fluid" src="<?php echo asset('assets/img/sinimagen.png' ); ?>" alt="" style="width: 250px;"
                                                <?php endif; ?>
                                            </div>
                                            <div class="col-md-12 col-12">
                                                <label class="control-label is-required">Nombre</label>
                                                <input class="form-control" value="<?php echo e($item->nombre_prca); ?>" type="text" name="nombre" required>
                                            </div>
                                            <div class="col-md-12 col-12">
                                                <label class="control-label">Imagen en tienda</label>
                                                <input class="form-control" type="file" name="imagen">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="submit" class="btn btn-success"><i class="bx bx-save"></i> Actualizar</button>
                                        <button type="button" class="btn btn-danger" data-bs-dismiss="modal"><i class="bx  bxs-x-circle"></i> Cerrar</button>
                                    </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                        <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
            <div class="datatable-bottom">
                <nav class="datatable-pagination">
                    <ul class="datatable-pagination-list"></ul>
                </nav>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php endif; ?>


<?php echo $__env->make('layouts/app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\keninails\resources\views/categorias/index.blade.php ENDPATH**/ ?>