<?php
$VerEditor = auth()->user()->can('Clientes - Visor') || auth()->user()->can('Clientes - Editor')
?>
<?php if($VerEditor): ?>

<?php $__env->startSection('tituloModulo', 'CLIENTES'); ?>
<?php $__env->startSection('contenido'); ?>
<div class="card">
    <div class="card-body">
        <div class="datatable-wrapper datatable-loading no-footer sortable searchable fixed-columns">
            <div class="datatable-container">
                <table class="table datatable datatable-table">
                    <thead>
                        <tr class="text">
                            <th data-sortable="true" scope="col">NOMBRE</th>
                            <th data-sortable="true" scope="col">TELÉFONO</th>
                            <th data-sortable="true" scope="col">CORREO</th>
                            <th data-sortable="true" scope="col">CIUDAD</th>
                            <th data-sortable="true" scope="col">ESTADO</th>
                            <th data-sortable="true" scope="col">PAÍS</th>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Clientes - Editor')): ?>
                            <th data-sortable="true" scope="col">ACCIÓN</th>
                            <?php endif; ?>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $datos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td data-title="NOMBRE"><?php echo e($item->nombre_cliente); ?></td>
                            <td data-title="TELÉFONO"><?php echo e($item->telefono_clie); ?></td>
                            <td data-title="CORREO"><?php echo e($item->email); ?></td>
                            <td data-title="CIUDAD"><?php echo e($item->ciudad_clie); ?></td>
                            <td data-title="ESTADO"><?php echo e($item->nombreEstado); ?></td>
                            <td data-title="PAÍS"><?php echo e($item->pais_clie); ?></td>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Clientes - Editor')): ?>
                            <td data-title="ACCIÓN">
                                <div class="btn-group">
                                    <button type="button" class="btn btn-outline-primary dropdown-toggle btnTabla"
                                        data-bs-toggle="dropdown" aria-expanded="false">Acción <i
                                            class="mdi mdi-chevron-down"></i></button>
                                    <div class="dropdown-menu">
                                        <button type="button" class="btn btn-outline-success mt-2 dropdown-item" data-bs-toggle="modal" data-bs-target="#editar<?php echo e($item->codigo_clie); ?>">
                                            <i class="fa-solid fa-eye"></i> Ver más
                                        </button>
                                    </div>
                                </div>
                            </td>
                            <?php endif; ?>
                        </tr>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Clientes - Editor')): ?>
                        <div class="modal fade" id="editar<?php echo e($item->codigo_clie); ?>" tabindex="-1">
                            <div class="modal-dialog modal-xl">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title">Ver Datos del Cliente</h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                    </div>
                                    <div class="modal-body">
                                            <div class="row">
                                                <h5 class="modal-title">Datos generales del cliente</h6>
                                            <div class="col-md-4 col-12">
                                                <label class="control-label is-required">Nombre</label>
                                                <input class="form-control" type="text"  value="<?php echo e($item->nombre_cliente); ?>" disabled>
                                            </div>
                                            <div class="col-md-4 col-12">
                                                <label class="control-label is-required">Teléfono</label>
                                                <input class="form-control" type="text"  value="<?php echo e($item->telefono_clie); ?>" disabled>
                                            </div>
                                            <div class="col-md-4 col-12">
                                                <label class="control-label is-required">Corrreo Electrónico</label>
                                                <input class="form-control" type="text"  value="<?php echo e($item->email); ?>" disabled>
                                            </div>
                                            <div class="col-md-4 col-12">
                                                <label class="control-label is-required">Estado</label>
                                                <input class="form-control" type="text"  value="<?php echo e($item->nombreEstado); ?>" disabled>
                                            </div>
                                            <div class="col-md-4 col-12">
                                                <label class="control-label is-required">Ciudad</label>
                                                <input class="form-control" type="text"  value="<?php echo e($item->ciudad_clie); ?>" disabled>
                                            </div>
                                            <div class="col-md-4 col-12">
                                                <label class="control-label is-required">País</label>
                                                <input class="form-control" type="text"  value="<?php echo e($item->pais_clie); ?>" disabled>
                                            </div>
                                            <div class="col-md-4 col-12">
                                                <label class="control-label is-required">Código Postal</label>
                                                <input class="form-control" type="text"  value="<?php echo e($item->codigo_postal_clie); ?>" disabled>
                                            </div>
                                            <div class="col-md-8 col-12">
                                                <label class="control-label is-required">Dirección</label>
                                                <input class="form-control" type="text"  value="<?php echo e($item->direccion_clie); ?>" disabled>
                                            </div>
                                            <hr class="mt-2">
                                            <h5 class="modal-title">Datos generales del cliente</h6>
                                            <div class="col-md-4 col-12">
                                                <label class="control-label is-required">Nombre o Empresa</label>
                                                <input class="form-control" type="text"  value="<?php echo e($item->nombre_facturacion_clie); ?>" disabled>
                                            </div>
                                            <div class="col-md-4 col-12">
                                                <label class="control-label is-required">RFC</label>
                                                <input class="form-control" type="text"  value="<?php echo e($item->rfc_facturacion_clie); ?>" disabled>
                                            </div>
                                            <div class="col-md-4 col-12">
                                                <label class="control-label is-required">Correo Electrónico</label>
                                                <input class="form-control" type="text"  value="<?php echo e($item->email_facturacion_clie); ?>" disabled>
                                            </div>
                                            <div class="col-md-4 col-12">
                                                <label class="control-label is-required">Uso de CDFI</label>
                                                <input class="form-control" type="text"  value="<?php echo e($item->uso_facturacion_clie); ?>" disabled>
                                            </div>
                                            <div class="col-md-4 col-12">
                                                <label class="control-label is-required">Regímen Fiscal</label>
                                                <input class="form-control" type="text"  value="<?php echo e($item->regimen_facturacion_clie); ?>" disabled>
                                            </div>
                                            <div class="col-md-4 col-12">
                                                <label class="control-label is-required">Código Postal</label>
                                                <input class="form-control" type="text"  value="<?php echo e($item->codigo_postal_facturacion_clie); ?>" disabled>
                                            </div>
                                            <?php if($item->constancia_facturacion_clie): ?>
                                            <div class="col-md-4 col-12">
                                                <a href="<?php echo e(route('clientes.descargar.documento', $item->codigo_clie )); ?>" class="btn btn-outline-primary mt-4" style="width: 100%" ><i class="bx bxs-cloud-download"></i> Descargar Constancia Fiscal</a>
                                            </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-danger" data-bs-dismiss="modal"><i class="bx  bxs-x-circle"></i> Cerrar</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
            <div class="datatable-bottom">
                <nav class="datatable-pagination">
                    <ul class="datatable-pagination-list"></ul>
                </nav>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php endif; ?>


<?php echo $__env->make('layouts/app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\keninails\resources\views/clientes/index.blade.php ENDPATH**/ ?>