<!DOCTYPE html>
<html>
    <head>
    <meta charset="utf-8">
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <style type="text/css">
    .logoEmpresaPDF{
        text-align:center;
        width:150px;
    }
    .tituloEmpresaPDF{
        text-align:center;
        width:400px;
        color: #003C8D;
    }
    .datosPDF{
        margin-left: auto;
        margin-right: auto;
        width: 100%;
        font-size: 12px;
    }
    .thDatosPDF{
        width: 5%;
        text-align: left;
        font-size: 12px;
    }
    .thDatosDPDF{
        width: 5%;
        text-align: LEFT;
        font-size: 12px;
    }
    .header {
        position: fixed;
        top: 0;
        left: 0;
        right: 0;
        text-align: center;
        padding: 12px;
    }
    /* Estilos para el contenido */
    .content {
        margin-top: 60px; /* Ajusta el margen superior para dejar espacio para el encabezado */
    }
    body {
        font-family: Arial, sans-serif;
        margin: 0;
        padding: 0;
    }
    .container {
        max-width: 600px;
        margin: 20px auto;
        padding: 20px;
        border: 1px solid #ccc;
        border-radius: 12px;
    }
    h1 { text-align: center; }
    h4 { text-align: center; }
    table {
        width: 100%;
        border-collapse: collapse;
        margin-top: 20px;
    }
    th, td {
        padding: 5px;
        border-bottom: 1px solid #ddd;
        text-align: left;
        font-size: 12px;
    }
    th { background-color: #f2f2f2; }
    tr.total {
        font-weight: bold; }
    td:last-child { text-align: right; }
    </style>
</head>
<body>
    <table>
        <tr>

            <td class="logoEmpresaPDF"> <img src="<?php echo e(public_path('/assets/img/logos/'. $empresas->logo_config )); ?>" alt="" width="100"></td>
            <td class="tituloEmpresaPDF"><h3>COMPROBANTE DE PAGO <br> <?php echo e("NO."); ?> <?php echo e($ultimaSolicitud); ?></h3></td>
        </tr>
    </table><br>
    <table class="datosPDF">
    <tr>
        <th  style="background-color: <?php echo e($empresas->color_pricipal_config); ?>; color:aliceblue; text-align: center;">DATOS DEL COMPRADOR</th>
    </tr>
    </table>
    <table class="datosPDF">
    <tr>
        <th class="thDatosPDF">NOMBRE: </th>
        <td style="text-align: LEFT; width: 10%;"><?php echo e($compra->nombre_comp); ?></td>
        <th class="thDatosPDF">CORREO ELECTRÓNICO: </th>
        <td style="text-align: LEFT; width: 10%;"><?php echo e($compra->email_comp); ?></td>
    </tr>
    <tr>
        <th class="thDatosDPDF">TELÉFONO:</th>
        <td style="text-align: LEFT; width: 10%;"><?php echo e($compra->telefono_comp); ?></td>
        <th class="thDatosPDF">PAÍS: </th>
        <?php if($compra->addDirecciones_comp): ?>
        <td style="text-align: LEFT; width: 10%;"><?php echo e($compra->pais_dire); ?></td>
        <?php else: ?>
        <td style="text-align: LEFT; width: 10%;"><?php echo e($compra->pais_comp); ?></td>
        <?php endif; ?>
    </tr>
    <tr>
        <th class="thDatosPDF">DIRECCIÓN: </th>
        <?php if($compra->addDirecciones_comp): ?>
        <td colspan="3" style="text-align: LEFT; width: 10%;"><?php echo e($compra->direccion_dire); ?></td>
        <?php else: ?>
        <td colspan="3" style="text-align: LEFT; width: 10%;"><?php echo e($compra->direccion_comp); ?></td>
        <?php endif; ?>
    </tr>
    <tr>
        <th class="thDatosPDF">CIUDAD: </th>
        <?php if($compra->addDirecciones_comp): ?>
        <td style="text-align: LEFT; width: 10%;"><?php echo e($compra->ciudad_dire); ?></td>
        <?php else: ?>
        <td style="text-align: LEFT; width: 10%;"><?php echo e($compra->ciudad_comp); ?></td>
        <?php endif; ?>
        <th class="thDatosPDF">ESTADO: </th>
        <?php if($compra->addDirecciones_comp): ?>
        <td style="text-align: LEFT; width: 10%;"><?php echo e($compra->nomEdo_dire); ?></td>
        <?php else: ?>
        <td style="text-align: LEFT; width: 10%;"><?php echo e($compra->nomEdo); ?></td>
        <?php endif; ?>
    </tr>
    <tr>
        <th class="thDatosPDF">CÓDIGO POSTAL: </th>
        <?php if($compra->addDirecciones_comp): ?>
        <td colspan="3" style="text-align: LEFT; width: 10%;"><?php echo e($compra->codigo_postal_dire); ?></td>
        <?php else: ?>
        <td colspan="3" style="text-align: LEFT; width: 10%;"><?php echo e($compra->cp_comp); ?></td>
        <?php endif; ?>
    </tr>
    </table>
    <?php if($compra->requiereFact): ?>
    <table class="datosPDF">
        <tr>
            <th  style="background-color: <?php echo e($empresas->color_pricipal_config); ?>; color:aliceblue; text-align: center;">DATOS DE FACTURACIÓN</th>
        </tr>
    </table>
    <table class="datosPDF">
        <tr>
            <th class="thDatosPDF">NOMBRE O EMPRESA: </th>
            <td style="text-align: LEFT; width: 10%;"><?php echo e($compra->nombre_fact_comp); ?></td>
            <th class="thDatosPDF">RFC: </th>
            <td style="text-align: LEFT; width: 10%;"><?php echo e($compra->rfc_fact_comp); ?></td>
        </tr>
        <tr>
            <th class="thDatosPDF">USO DE FACTURA: </th>
            <td style="text-align: LEFT; width: 10%;"><?php echo e($compra->uso_fact_comp); ?></td>
            <th class="thDatosPDF">CORREO ELECTRÓNICO: </th>
            <td style="text-align: LEFT; width: 10%;"><?php echo e($compra->email_fact_comp); ?></td>
        </tr>
        <tr>
            <th class="thDatosPDF">RÉGIMEN FISCAL: </th>
            <td style="text-align: LEFT; width: 10%;"><?php echo e($compra->regime_fact_comp); ?></td>
            <th class="thDatosPDF">CÓDIGO POSTAL: </th>
            <td style="text-align: LEFT; width: 10%;"><?php echo e($compra->cp_fact_comp); ?></td>
        </tr>
    </table>
    <?php endif; ?>
    <table class="datosPDF">
        <tr>
            <th  style="background-color: <?php echo e($empresas->color_pricipal_config); ?>; color:aliceblue; text-align: center;">DETALLE DE LA COMPRA</th>
        </tr>
    </table>
    <div class="container">
        <table>
            <tr>
                <th>CONCEPTO</th>
                <th style="text-align: center">COSTO</th>
                <th style="text-align: center">CANTIDAD</th>
                <th style="text-align: right">TOTAL</th>
            </tr>
            <?php $__currentLoopData = $productos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $producto): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td>
                    <span class="input-group-text"><?php echo e($producto->nombreProduct_pedi); ?><?php if($producto->talla_pedi): ?>, Talla: <?php echo e($producto->talla_pedi); ?> <?php endif; ?> </span>
                    <?php if($producto->colorHtml_pedi): ?>
                    <span class="input-group-text">Color: </span>
                    <div style="display: inline-block; width: 20px; height: 20px; background-color: <?php echo e($producto->colorHtml_pedi); ?>; border-radius: 50%;"></div>
                    <?php endif; ?>
                </td>
                <td style="text-align: center"><?php echo e($producto->costoProduct_pedi); ?></td>
                <td style="text-align: center"><?php echo e($producto->cantidad_pedi); ?></td>
                <td><?php echo e("$" . number_format($producto->total_pedi, 2)); ?></td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <tr class="total">
                <td colspan="3">SUBTOTAL</td>
                <td><?php echo e("$" . number_format($compra->sub_total_comp, 2)); ?></td>
            </tr>
            <tr class="total">
                <td colspan="3">DESCUENTO</td>
                <td><?php echo e("$" . number_format($compra->descuento_comp, 2)); ?></td>
            </tr>
            <tr class="total">
                <td colspan="3">ENVIÓ</td>
                <td><?php echo e("$" . number_format($compra->envio_comp, 2)); ?></td>
            </tr>
            <tr class="total">
                <td colspan="3">TOTAL</td>
                <td><?php echo e("$" . number_format($compra->total_comp, 2)); ?></td>
            </tr>
        </table>
    </div>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\keninails\resources\views/tienda/comprobante_pago.blade.php ENDPATH**/ ?>