<?php
$VerEditor = auth()->user()->can('Pedidos - Visor') || auth()->user()->can('Pedidos - Editor')
?>
<?php if($VerEditor): ?>

<?php $__env->startSection('tituloModulo', 'PEDIDOS'); ?>
<?php $__env->startSection('contenido'); ?>
<div class="card">
    <div class="card-body">
        <div class="datatable-wrapper datatable-loading no-footer sortable searchable fixed-columns">
            <div class="datatable-container">
                <table class="table datatable datatable-table">
                    <thead>
                        <tr class="text">
                            <th data-sortable="true" scope="col"><?php echo e("NO. COMPRA"); ?></th>
                            <th data-sortable="true" scope="col">ID MERCADO PAGO</th>
                            <th data-sortable="true" scope="col">NOMBRE</th>
                            <th data-sortable="true" scope="col">TELÉFONO</th>
                            <th data-sortable="true" scope="col">CORREO ELECTRÓNICO</th>
                            <th data-sortable="true" scope="col">SUBTOTAL</th>
                            <th data-sortable="true" scope="col">DESCUENTO</th>
                            <th data-sortable="true" scope="col">TOTAL</th>
                            <th data-sortable="true" scope="col">REQUIERE FACTURA</th>
                            <th data-sortable="true" scope="col">ESTATUS</th>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Pedidos - Editor')): ?>
                            <th data-sortable="true" scope="col">ACCIÓN</th>
                            <?php endif; ?>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $datos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td data-title="<?php echo e("NO. COMPRA"); ?>"><?php echo e($item->numero_pago); ?></td>
                            <td data-title="ID MERCADO PAGO"><?php echo e($item->payment_id_paco); ?></td>
                            <td data-title="NOMBRE"><?php echo e($item->nombre_comp); ?></td>
                            <td data-title="TELÉFONO"><?php echo e($item->telefono_comp); ?></td>
                            <td data-title="CORREO ELECTRÓNICO"><?php echo e($item->email_comp); ?></td>
                            <td data-title="SUBTOTAL"><?php echo e("$" . number_format($item->sub_total_comp, 2)); ?></td>
                            <td data-title="DESCUENTO"><?php echo e("$" . number_format($item->descuento_comp, 2)); ?></td>
                            <td data-title="TOTAL"><?php echo e("$" . number_format($item->total_comp, 2)); ?></td>
                            <td data-title="REQUIERE FACTURA"><?php if($item->requiereFact): ?> Requiere Factura <?php else: ?> Sin Factura <?php endif; ?> </td>
                            <td data-title="ESTATUS">
                                <?php if($item->estatus_paco == 'Pagado'): ?>
                                    <span class="badge bg-warning"><?php echo e($item->estatus_paco); ?></span>
                                <?php endif; ?>
                                <?php if($item->estatus_paco == 'Enviado'): ?>
                                    <span class="badge bg-primary"><?php echo e($item->estatus_paco); ?></span>
                                <?php endif; ?>
                                <?php if($item->estatus_paco == 'Entregado'): ?>
                                    <span class="badge bg-success"><?php echo e($item->estatus_paco); ?></span>
                                <?php endif; ?>
                            </td>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Pedidos - Editor')): ?>
                            <td data-title="ACCIÓN">
                                <div class="btn-group">
                                    <button type="button" class="btn btn-outline-primary dropdown-toggle btnTabla"
                                        data-bs-toggle="dropdown" aria-expanded="false">Acción <i
                                            class="mdi mdi-chevron-down"></i></button>
                                    <div class="dropdown-menu">
                                        <form action="<?php echo e(route('pedidos.downloadPDFOC', $item->cod_pago_paco)); ?>" method="GET">
                                            <button type="submit" class="btn btn-outline-success mt-2 dropdown-item">
                                                <i class="fa-solid fa-file-pdf"></i> Ver Orden de Compra
                                            </button>
                                        </form>
                                        <?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'Administrador')): ?>
                                        <form action="<?php echo e(route('pedidos.update', ['estatus'=>'Enviado','id'=>$item->codigo_paco])); ?>" method="POST" class="form-enviar">
                                            <?php echo csrf_field(); ?>
                                            <button class="dropdown-item"   type="submit" id="btn" >
                                                <i class="fa-solid fa-truck"></i> Enviar
                                            </button>
                                        </form>
                                        <form action="<?php echo e(route('pedidos.update', ['estatus'=>'Entregado','id'=>$item->codigo_paco])); ?>" method="POST" class="form-entregar">
                                            <?php echo csrf_field(); ?>
                                            <button class="dropdown-item"   type="submit" id="btn" >
                                                <i class="fa-solid fa-truck-ramp-box"></i> Entregar
                                            </button>
                                        </form>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </td>
                            <?php endif; ?>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
            <div class="datatable-bottom">
                <nav class="datatable-pagination">
                    <ul class="datatable-pagination-list"></ul>
                </nav>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php endif; ?>


<?php echo $__env->make('layouts/app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\tienda\resources\views/pedidos/index.blade.php ENDPATH**/ ?>