<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title class="nombre_empresa"></title>
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <meta content="Free HTML Templates" name="keywords">
    <meta content="Free HTML Templates" name="description">
    <!-- Favicon -->
    <link href="<?php echo asset('assets/store/img/favicon.ico'); ?>" rel="icon">
    <!-- Google Web Fonts -->
    <link rel="preconnect" href="https://fonts.gstatic.com">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" integrity="sha512-1ycn6IcaQQ40/MKBW2W4Rhis/DbILU74C1vSrLJxCq57o941Ym01SwNsOMqvEBFlcgUa6xLiPY/NS5R+E6ztJQ==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <!-- Libraries Stylesheet -->
    <link href="<?php echo asset('assets/store/lib/owlcarousel/assets/owl.carousel.min.css'); ?>" rel="stylesheet">
    <!-- Customized Bootstrap Stylesheet -->
    <link href="<?php echo asset('assets/store/css/style.css'); ?>" rel="stylesheet">
    <link href="css/style.css" rel="stylesheet">
    <script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
</head>
<body>
    <!-- Topbar Start -->
    <div class="container-fluid">
        <div class="row py-2 px-xl-5 color-principal-encabezado" style="background-color: #ffffff;">
            <div class="col-lg-6 d-none d-lg-block">
                <div class="d-inline-flex align-items-center">
                </div>
            </div>
            <div class="col-lg-6 text-center text-lg-right">
                <div class="d-inline-flex align-items-center">
                    <a class="text-dark px-2" href="#" id="facebook-link" _blank>
                        <i class="fab fa-facebook-f"></i>
                    </a>
                    <a class="text-dark px-2" href="#" id="instagram-link" _blank>
                        <i class="fab fa-instagram"></i>
                    </a>
                    <a class="text-dark px-2" href="#" id="youtube-link" _blank>
                        <i class="fab fa-youtube"></i>
                    </a>
                    <a class="text-dark pl-2" href="#" id="tiktok-link" _blank>
                        <i class="fab fa-tiktok"></i>
                    </a>
                </div>
            </div>
        </div>
        <div class="row align-items-center py-3 px-xl-5">
            <div class="col-lg-3 d-none d-lg-block">
                <a href="<?php echo e(route('index')); ?>" class="text-decoration-none">
                    <h1 class="m-0 display-5 font-weight-semi-bold"><img alt="logo" class="logo_empresa" width="50"><span class="nombre_empresa"></span></h1>
                </a>
            </div>
            <div class="col-lg-6 col-6 text-left">
                <form action="<?php echo e(route('filtro')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="input-group">
                        <input type="text" class="form-control" placeholder="Buscar producto" name="buscar">
                        <div class="input-group-append">
                            <button type="submit" class="input-group-text bg-transparent color-principal-color border-0">
                                <i class="fa fa-search"></i>
                            </button>
                        </div>
                    </div>
                </form>
            </div>
            <div class="col-lg-3 col-6 text-right">
                <a href="<?php echo e(route('favoritos')); ?>" class="btn border">
                    <i class="fas fa-heart color-principal-color"></i>
                    <span class="badge"><?php echo e($totalFavoritos); ?></span>
                </a>
                <a href="<?php echo e(route('carrito')); ?>" class="btn border">
                    <i class="fas fa-shopping-cart color-principal-color"></i>
                    <span class="badge totalProds" ><?php echo e($totalProducts); ?></span>
                </a>
            </div>
        </div>
    </div>
    <!-- Topbar End -->
    <!-- Navbar End -->
    <?php echo $__env->yieldContent('contenido'); ?>
    <!-- Footer Start -->
    <div class="container-fluid  text-dark mt-5 pt-5 color-principal-encabezado" style="background-color: #ffffff;">
        <div class="row px-xl-5 pt-5">
            <div class="col-lg-4 col-md-12 mb-5 pr-3 pr-xl-5">
                <a href="" class="text-decoration-none">
                    <h1 class="mb-4 display-5 font-weight-semi-bold"><img alt="logo" class="logo_empresa" width="50"><span class="nombre_empresa"></span></h1>
                </a>
                <p class="mensaje_footer_empresa"></p>
                <p class="mb-2 direccion_empresa"><i class="fa fa-map-marker-alt color-principal-color mr-3"></i></p>
                <p class="mb-2 correo_empresa"><i class="fa fa-envelope color-principal-color mr-3"></i></p>
                <p class="mb-0 telefono_empresa"><i class="fa fa-phone-alt color-principal-color mr-3"></i></p>
            </div>
            <div class="col-lg-8 col-md-12">
                <div class="row">
                    <div class="col-md-4 mb-5">
                        <h5 class="font-weight-bold text-dark mb-4">URLs</h5>
                        <div class="d-flex flex-column justify-content-start">
                            <a class="text-dark mb-2" href="<?php echo e(route('index')); ?>"><i class="fa fa-angle-right mr-2"></i>Inicio</a>
                            <a class="text-dark mb-2" href="<?php echo e(route('catalogo')); ?>"><i class="fa fa-angle-right mr-2"></i>Tienda</a>
                            <a class="text-dark mb-2" href="<?php echo e(route('carrito')); ?>"><i class="fa fa-angle-right mr-2"></i>Carrito</a>
                        </div>
                    </div>
                    <div class="col-md-4 mb-5">
                        <h5 class="font-weight-bold text-dark mb-4">Visita nuestras redes sociales</h5>
                        <div class="d-flex flex-column justify-content-start">
                            <a id="facebook-links"  class="text-dark mb-2" _blank><i class="fa fa-angle-right mr-2"></i>Facebook</a>
                            <a id="instagram-links"  class="text-dark mb-2" _blank><i class="fa fa-angle-right mr-2"></i>Instagram</a>
                            <a id="youtube-links"  class="text-dark mb-2" _blank><i class="fa fa-angle-right mr-2"></i>Youtube</a>
                            <a id="tiktok-links"  class="text-dark mb-2" _blank><i class="fa fa-angle-right mr-2"></i>Tiktok</a>
                        </div>
                    </div>
                    <div class="col-md-4 mb-5">
                        <h5 class="font-weight-bold text-dark mb-4">Suscribete</h5>
                        <form class="suscribirForm">
                            <?php echo csrf_field(); ?>
                            <div class="form-group">
                                <input type="email" name="email" class="form-control border-0 py-4" placeholder="Correo electrónico" required="required" />
                            </div>
                            <div>
                                <button type="submit"  class="btn color-principal btn-block border-0 py-3" style="color: #ffffff">Subscribir ahora</button>
                            </div>
                        </form>
                        <script>
                            $(document).ready(function() {
                                $('.suscribirForm').on('submit', function(e) {
                                    e.preventDefault();
                                    $.ajax({
                                        url: "<?php echo e(route('suscribir')); ?>",
                                        method: "POST",
                                        data: $(this).serialize(),
                                        success: function(response) {
                                            Swal.fire({
                                                icon: 'success',
                                                title: '¡Gracias por suscribirte!',
                                                text: 'Te has suscrito exitosamente.',
                                            }).then(() => {
                                                // Limpiar el campo de correo
                                                $('#suscribirForm')[0].reset();
                                            });
                                        },
                                        error: function(xhr) {
                                            let errors = xhr.responseJSON.errors;
                                            let errorMessages = '';
                                            for (let error in errors) {
                                                if (errors.hasOwnProperty(error)) {
                                                    errorMessages += errors[error][0] + '\n';
                                                }
                                            }
                                            Swal.fire({
                                                icon: 'error',
                                                title: 'Error',
                                                text: errorMessages,
                                            });
                                        }
                                    });
                                });
                            });
                        </script>
                    </div>
                </div>
            </div>
        </div>
        <div class="row border-top border-light mx-xl-5 py-4">
            <div class="col-md-6 px-xl-0">
                <p class="mb-md-0 text-center text-md-left text-dark">
                    &copy; <a class="text-dark font-weight-semi-bold nombre_empresa" href="<?php echo e(route('index')); ?>"></a>. Derechos reservados
                </p>
            </div>
            <div class="col-md-6 px-xl-0 text-center text-md-right">
                <img class="img-fluid" src="img/payments.png" alt="">
            </div>
        </div>
    </div>
    <!-- Footer End -->
    <!-- Back to Top -->
    <a href="#" class="btn btn-primary back-to-top"><i class="fa fa-angle-double-up"></i></a>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="<?php echo asset('tienda/assets/js/vendor/jquery-3.6.3.min.js'); ?>"></script>
    <?php if($mensaje = Session::get('success')): ?>
        <script>
            $(document).ready(function() {
                Swal.fire({
                    title: '¡Éxito!',
                    text: '<?php echo e(session('success')); ?>',
                    icon: 'success',
                    confirmButtonText: 'OK'
                });
            });
        </script>
    <?php endif; ?>
    <?php if($mensaje = Session::get('danger')): ?>
        <script>
            $(document).ready(function() {
                Swal.fire({
                    title: '¡Error!',
                    text: '<?php echo e(session('danger')); ?>',
                    icon: 'error',
                    confirmButtonText: 'OK'
                });
            });
        </script>
    <?php endif; ?>
    <?php if($mensaje = Session::get('warning')): ?>
        <script>
            $(document).ready(function() {
                Swal.fire({
                    title: '¡Error!',
                    text: '<?php echo e(session('warning')); ?>',
                    icon: 'error',
                    confirmButtonText: 'OK'
                });
            });
        </script>
    <?php endif; ?>
    <!-- JavaScript Libraries -->
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.4.1/js/bootstrap.bundle.min.js"></script>
    <script src="<?php echo asset('assets/store/lib/easing/easing.min.js'); ?>"></script>
    <script src="<?php echo asset('assets/store/lib/owlcarousel/owl.carousel.min.js'); ?>"></script>
    <!-- Contact Javascript File -->
    <script src="<?php echo asset('assets/store/mail/jqBootstrapValidation.min.js'); ?>"></script>
    <script src="<?php echo asset('assets/store/mail/contact.js'); ?>"></script>
    <!-- Template Javascript -->
    <script src="<?php echo asset('assets/store/js/main.js'); ?>"></script>
    <script>
        $(document).ready(function() {
                $.ajax({
                    url: '<?php echo e(route('empresa')); ?>', // URL de la ruta
                    type: 'GET',
                    success: function(response) {
                        var facebookUrl = response.facebook_config;
                        if(!facebookUrl){ $('#facebook-link').hide(); $('#facebook-links').hide(); } else { $('#facebook-link').attr('href', facebookUrl); $('#facebook-links').attr('href', facebookUrl); }
                        var instagramUrl = response.instagram_config;
                        if(!instagramUrl){ $('#instagram-link').hide(); $('#instagram-links').hide(); } else { $('#instagram-link').attr('href', instagramUrl); $('#instagram-links').attr('href', instagramUrl);}
                        var youtubeUrl = response.youtube_config;
                        if(!youtubeUrl){ $('#youtube-link').hide(); $('#youtube-links').hide();} else { $('#youtube-link').attr('href', youtubeUrl); $('#youtube-links').attr('href', youtubeUrl);}
                        var tiktokUrl = response.tiktok_config;
                        if(!tiktokUrl){ $('#tiktok-link').hide(); $('#tiktok-links').hide();} else { $('#tiktok-link').attr('href', tiktokUrl); $('#tiktok-links').attr('href', tiktokUrl);}
                        var colorPrincipal = response.color_pricipal_config;
                        if (colorPrincipal) {
                            $('.color-principal-encabezado').css('background-color', colorPrincipal + "80");
                            $('.color-principal').css('background-color', colorPrincipal);
                            $('.color-principal-color').css('color', colorPrincipal);
                        }
                        var nombreEmpresa = response.empresa_config;
                        $('.nombre_empresa').text(nombreEmpresa)
                        var direcciomEmpresa = response.direccion_config;
                        var correoEmpresa = response.email_config;
                        var telefonoEmpresa = response.telefono_config;
                        var mensajeFooter = response.mensaje_footer_config;
                        var logo = response.logo_config;
                        if (typeof logo !== 'undefined' && logo) {
                            var src = "<?php echo asset('assets/img/logos/'); ?>/" + logo;
                            $('.logo_empresa').attr('src', src);
                        } else {
                            var src = "<?php echo asset('assets/img/logos/logo.png'); ?>";
                            $('.logo_empresa').attr('src', src);
                        }
                        if(!direcciomEmpresa){ $('.direccion_empresa').hide(); } else { $('.direccion_empresa').append(direcciomEmpresa);}
                        if(!correoEmpresa){ $('.correo_empresa').hide(); } else { $('.correo_empresa').append(correoEmpresa);}
                        if(!telefonoEmpresa){ $('.telefono_empresa').hide(); } else { $('.telefono_empresa').append(telefonoEmpresa);}
                        if(!mensajeFooter){ $('.mensaje_footer_empresa').hide(); } else { $('.mensaje_footer_empresa').append(mensajeFooter);}
                    },
                    error: function(xhr) {
                        console.error('Error:', xhr);
                    }
                });
            });
    </script>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\tienda\resources\views/tienda/layout.blade.php ENDPATH**/ ?>