<?php $__env->startSection('contenido'); ?>
<style>
    .color-circle {
        display: inline-block;
        width: 30px;
        height: 30px;
        border-radius: 50%;
        border: 5px solid #ccc;
        cursor: pointer;
        transition: border-color 0.3s; /* Transición suave para el cambio de color del borde */
    }
    /* Estilo para el borde dorado cuando el radio button está seleccionado */
    .custom-control-input:checked ~ .color-circle {
        border-color: gold;
    }
</style>
<!-- Navbar Start -->
    <div class="container-fluid">
        <div class="row border-top px-xl-5">
            <div class="col-lg-3 d-none d-lg-block">
                <a class="btn shadow-none d-flex align-items-center justify-content-between color-principal text-white w-100" data-toggle="collapse" href="#navbar-vertical" style="height: 65px; margin-top: -1px; padding: 0 30px;  background-color: #ffffff;" >
                    <h6 class="m-0">Categorías</h6>
                    <i class="fa fa-angle-down text-dark"></i>
                </a>
                <nav class="collapse position-absolute navbar navbar-vertical navbar-light align-items-start p-0 border border-top-0 border-bottom-0 bg-light" id="navbar-vertical" style="width: calc(100% - 30px); z-index: 1;">
                    <div class="navbar-nav w-100 overflow-hidden" style="height: 410px">
                        <div class="nav-item dropdown">
                            <a href="#" class="nav-link" data-toggle="dropdown">Subcategoría <i class="fa fa-angle-down float-right mt-1"></i></a>
                            <div class="dropdown-menu position-absolute bg-secondary border-0 rounded-0 w-100 m-0">
                                <?php $__currentLoopData = $subcategorias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subcategoria): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <form action="<?php echo e(route('filtro')); ?>" method="POST" id="form-<?php echo e($subcategoria->codigo_prsu); ?>">
                                    <?php echo csrf_field(); ?>
                                    <a href="#" class="dropdown-item" onclick="document.getElementById('form-<?php echo e($subcategoria->codigo_prsu); ?>').submit(); return false;">
                                    <?php echo e($subcategoria->nombre_prsu); ?></a>
                                    <input type="hidden" name="subcategoria[]" value="<?php echo e($subcategoria->codigo_prsu); ?>">
                                </form>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                        <?php $__currentLoopData = $categorias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $categoria): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <form action="<?php echo e(route('filtro')); ?>" method="POST" id="form-<?php echo e($categoria->codigo_prca); ?>">
                            <?php echo csrf_field(); ?>
                            <a href="#" class="nav-item nav-link" onclick="document.getElementById('form-<?php echo e($categoria->codigo_prca); ?>').submit(); return false;">
                            <?php echo e($categoria->nombre_prca); ?></a>
                            <input type="hidden" name="categoria[]" value="<?php echo e($categoria->codigo_prca); ?>">
                        </form>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </nav>
            </div>
            <div class="col-lg-9">
                <nav class="navbar navbar-expand-lg bg-light navbar-light py-3 py-lg-0 px-0">
                    <a href="" class="text-decoration-none d-block d-lg-none">
                        <h1 class="m-0 display-5 font-weight-semi-bold"><img alt="logo" class="logo_empresa" width="50"><span class="nombre_empresa"></span></h1>
                    </a>
                    <button type="button" class="navbar-toggler" data-toggle="collapse" data-target="#navbarCollapse">
                        <span class="navbar-toggler-icon"></span>
                    </button>
                    <div class="collapse navbar-collapse justify-content-between" id="navbarCollapse">
                        <div class="navbar-nav mr-auto py-0">
                            <a href="<?php echo e(route('index')); ?>" class="nav-item nav-link active">Inicio</a>
                            <a href="<?php echo e(route('catalogo')); ?>" class="nav-item nav-link">Tienda</a>
                            <a href="<?php echo e(route('carrito')); ?>" class="nav-item nav-link">Carrito</a>
                            <a href="<?php echo e(route('contacto')); ?>" class="nav-item nav-link">Contacto</a>
                        </div>
                        <div class="navbar-nav ml-auto py-0">
                            <?php if(Auth::check()): ?>
                            <a href="<?php echo e(route('home')); ?>" class="nav-item nav-link">Panel de control</a>
                            <?php else: ?>
                            <a href="<?php echo e(route('login')); ?>" class="nav-item nav-link">Acceso</a>
                            <a href="<?php echo e(route('register')); ?>" class="nav-item nav-link">Registro</a>
                            <?php endif; ?>
                        </div>
                    </div>
                </nav>
            </div>
        </div>
    </div>
    <!--HEADER INICIO -->
    <div class="container-fluid">
        <div class="d-flex flex-column align-items-center justify-content-center" style="min-height: 50px">
            <h1 class="font-weight-semi-bold text-uppercase">Detalle del producto</h1>
            <div class="d-inline-flex">
                <p class="m-0"><a href="<?php echo e(route('index')); ?>" class="color-principal-color">Inicio</a></p>
                <p class="m-0 px-2">-</p>
                <p class="m-0">Catálogo</p>
            </div>
        </div>
    </div>
    <!--HEADER FIN -->
    <!-- CONTENIDO INICIO-->
    <div class="container-fluid py-5">
        <div class="row px-xl-5">
            <div class="col-lg-5 pb-5">
                <div id="product-carousel" class="carousel slide" data-ride="carousel">
                    <div class="carousel-inner border">
                        <div class="carousel-item active">
                            <img class="w-100 h-100" src="<?php echo asset('assets/img/productos/'.$producto->imagen_principal_prod); ?>" alt="Image">
                        </div>
                        <?php $__currentLoopData = $imagenes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $imagen): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="carousel-item">
                        <img class="w-100 h-100" src="<?php echo asset('assets/img/productos/'.$imagen->imagen_prim); ?>" alt="Image">
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <a class="carousel-control-prev" href="#product-carousel" data-slide="prev">
                        <i class="fa fa-2x fa-angle-left text-dark"></i>
                    </a>
                    <a class="carousel-control-next" href="#product-carousel" data-slide="next">
                        <i class="fa fa-2x fa-angle-right text-dark"></i>
                    </a>
                </div>
            </div>
            <div class="col-lg-7 pb-5">
                <h3 class="font-weight-semi-bold"><?php echo e($producto->nombre_prod); ?> </h3>
                <div class="d-flex mb-3">
                    <div class="color-principal-color mr-2">
                        <small class="fas fa-star"></small>
                        <small class="fas fa-star"></small>
                        <small class="fas fa-star"></small>
                        <small class="fas fa-star"></small>
                        <small class="fas fa-star"></small>
                    </div>
                    <small class="pt-1">(50 Reviews)</small>
                </div>
                <?php if($conteoTallas >= 1): ?>
                <h3 class="font-weight-semi-bold mb-4"id="valor">¡Seleccione una talla!</h3>
                <?php else: ?>
                <h3 class="font-weight-semi-bold mb-4" id="valor"><?php echo e($producto->venta_prod); ?></h3>
                <?php endif; ?>
                <input id="valorInput" name="valorPrecio" type="hidden">
                <input id="codigoInput" name="codigo" type="hidden">
                <div id="csrfToken" data-token="<?php echo e(csrf_token()); ?>"></div>
                <p class="mb-4"><?php echo $producto->descripcion_corta_prod; ?></p>
                <?php if($conteoTallas >= 1): ?>
                <div class="d-flex mb-3">
                    <p class="text-dark font-weight-medium mb-0 mr-3">Tallas:</p>
                    <?php $__currentLoopData = $tallas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $talla): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="custom-control custom-radio custom-control-inline">
                        <input type="radio" class="custom-control-input talla" id="<?php echo e($talla->codigo_prta); ?>" name="talla" data-precio="<?php echo e($talla->venta_prta); ?>" data-codigo="<?php echo e($talla->codigo_prta); ?>">
                        <label class="custom-control-label" for="<?php echo e($talla->codigo_prta); ?>"><?php echo e($talla->talla_prta); ?></label>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <?php endif; ?>
                <?php if($coloresConteo >= 1): ?>
                <div class="d-flex mb-4">
                    <p class="text-dark font-weight-medium mb-0 mr-3">Colors:</p>
                    <?php $__currentLoopData = $colores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $color): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="custom-control custom-radio custom-control-inline">
                        <input type="radio" class="custom-control-input color" id="<?php echo e($color->codigo_prco); ?>" value="<?php echo e($color->codigo_prco); ?>" name="color">
                        <label for="<?php echo e($color->codigo_prco); ?>" class="color-circle" style="background-color: <?php echo e($color->color_prco); ?>"></label>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <?php endif; ?>
                <div class="d-flex align-items-center mb-4 pt-2">
                    <div class="input-group quantity mr-3" style="width: 130px;">
                        <div class="input-group-btn">
                            <button class="btn color-principal btn-minus" style="color: #ffffff;">
                            <i class="fa fa-minus"></i>
                            </button>
                        </div>
                        <input type="text" class="form-control bg-secondary text-center cantidad" value="1" id="cantidad" name="cantidad">
                        <div class="input-group-btn">
                            <button class="btn color-principal btn-plus"style="color: #ffffff;">
                                <i class="fa fa-plus"></i>
                            </button>
                        </div>
                    </div>
                    <button class="btn px-3 agregarCarrito color-principal" data-producto="<?php echo e($producto->codigo_prod); ?>" style="color: #ffffff;"><i class="fa fa-shopping-cart mr-1"></i> Agregar al carrito</button>
                </div>
                <div class="d-flex pt-2">
                    <p class="text-dark font-weight-medium mb-0 mr-2">Compartir con</p>
                    <div class="d-inline-flex">
                        <a class="color-principal-color px-2" id="facebookShareLink" target="_blank">
                            <i class="fab fa-facebook-f"></i>
                        </a>
                        <a class="color-principal-color px-2" id="whatsappShareLink" href="#" target="_blank">
                            <i class="fab fa-whatsapp"></i>
                        </a>
                    </div>
                    <script>
                        document.addEventListener('DOMContentLoaded', (event) => {
                            // Obtener la URL actual de la página
                            const currentUrlF = window.location.href;
                            // Construir la URL de compartir en Facebook
                            const facebookShareUrl = `https://www.facebook.com/sharer/sharer.php?u=${encodeURIComponent(currentUrlF)}`;
                            // Actualizar el enlace
                            document.getElementById('facebookShareLink').setAttribute('href', facebookShareUrl);
                            const currentUrlW = window.location.href;
                            // Construir la URL de compartir en WhatsApp
                            const whatsappShareUrl = `https://api.whatsapp.com/send?text=${encodeURIComponent(currentUrlW)}`;
                            // Actualizar el enlace
                            document.getElementById('whatsappShareLink').setAttribute('href', whatsappShareUrl);
                        });
                    </script>
                </div>
                <a href="<?php echo e(route('agregar.favoritos', $producto->codigo_prod)); ?>" class="btn color-principal px-3" style="color: #ffffff;"><i class="fas fa-heart"></i> Agregar al favoritos</a>
            </div>
        </div>
        <div class="row px-xl-5">
            <div class="col">
                <div class="nav nav-tabs justify-content-center border-secondary mb-4">
                    <a class="nav-item nav-link active" data-toggle="tab" href="#tab-pane-1">Descripción</a>
                    <a class="nav-item nav-link" data-toggle="tab" href="#tab-pane-3">Reseñas (<?php echo e($comentariosConteo); ?>)</a>
                </div>
                <div class="tab-content">
                    <div class="tab-pane fade show active" id="tab-pane-1">
                        <h4 class="mb-3">Descripción del producto</h4>
                        <p><?php echo $producto->descripcion_larga_prod; ?></p>
                    </div>
                    <div class="tab-pane fade" id="tab-pane-3">
                        <div class="row">
                            <div class="col-md-8 col-12">
                                <h4 class="mb-4"><?php echo e($comentariosConteo); ?> Reseña de <?php echo e($producto->nombre_prod); ?></h4>
                                <?php $__currentLoopData = $comentarios; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $comentario): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="media mb-4">
                                    <img src="<?php echo asset('assets/img/avatar.png'); ?>"  class="rounded-circle" alt="Image" class="img-fluid mr-3 mt-1" style="width: 45px;">
                                    <div class="media-body">
                                        <h6><?php echo e($comentario->name); ?><small> - <i><?php echo e(date("d/m/Y", strtotime($comentario->fecha_calif))); ?></i></small></h6>
                                        <div class="color-principal-color mb-2">
                                            <?php
                                                $filledStars = $comentario->calificacion_calif;
                                                $emptyStars = 5 - $filledStars;
                                            ?>
                                            <?php for($i = 0; $i < $filledStars; $i++): ?>
                                            <i class="fas fa-star"></i>
                                            <?php endfor; ?>
                                            <?php for($i = 0; $i < $emptyStars; $i++): ?>
                                                <i class="far fa-star"></i>
                                            <?php endfor; ?>
                                        </div>
                                        <p><?php echo e($comentario->resena_calif); ?></p>
                                    </div>
                                </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                            <div class="col-md-4 col-12">
                                <h4 class="mb-4">Dejanos un comentario del producto</h4>
                                <small>Valoramos profundamente tus comentarios, ya que nos brindan la oportunidad de mejorar constantemente la calidad de nuestros productos.</small>
                                <form method="post" action="<?php echo e(route('calificar', $producto->codigo_prod)); ?>">
                                    <?php echo csrf_field(); ?>
                                    <div class="d-flex my-3">
                                        <p class="mb-0 mr-2">Calificación * :</p>
                                        <div class="color-principal-color" id="rating-stars">
                                            <i class="far fa-star" data-rating="1"></i>
                                            <i class="far fa-star" data-rating="2"></i>
                                            <i class="far fa-star" data-rating="3"></i>
                                            <i class="far fa-star" data-rating="4"></i>
                                            <i class="far fa-star" data-rating="5"></i>
                                        </div>
                                        <input type="hidden" name="rating" id="rating" value="0">
                                    </div>
                                    <div class="form-group">
                                        <label for="message">Tu reseña *</label>
                                        <textarea id="message" cols="30" rows="5" name="mensaje" class="form-control" required></textarea>
                                    </div>
                                    <?php if(Auth::check()): ?>
                                    <div class="form-group mb-0">
                                        <input type="submit" value="Enviar Reseña" class="btn px-3 color-principal" style="color: #ffffff;">
                                    </div>
                                    <?php else: ?>
                                    <div class="form-group mb-0">
                                        <div class="alert alert-danger" role="alert">
                                            Para calificar el producto es necesario registrarse
                                        </div>
                                    </div>
                                    <?php endif; ?>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="container-fluid py-5">
        <div class="text-center mb-4">
            <h2 class="section-title px-5"><span class="px-2">Productos similares</span></h2>
        </div>
        <div class="row px-xl-5">
            <div class="col">
                <div class="owl-carousel related-carousel">
                    <?php $__currentLoopData = $productosSimilares; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $productoSimilar): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="card product-item border-0 mb-4">
                        <div class="card-header product-img position-relative overflow-hidden bg-transparent border p-0">
                            <?php if($producto->imagen_principal_prod): ?>
                                <a href="<?php echo e(route('detalle.producto', $productoSimilar->codigo_prod)); ?>"><img class="img-fluid w-100"  src="<?php echo e(asset('assets/img/productos/' . $productoSimilar->imagen_principal_prod)); ?>" alt=""></a>
                                <?php else: ?>
                                <a href="<?php echo e(route('detalle.producto', $productoSimilar->codigo_prod)); ?>"><img class="img-fluid w-100"  src="<?php echo asset('assets/img/products.png'); ?>" alt=""></a>
                            <?php endif; ?>
                        </div>
                        <div class="card-body border-left border-right text-center p-0 pt-4 pb-3">
                            <h6 class="text-truncate mb-3"><?php echo e($productoSimilar->nombre_prod); ?></h6>
                            <div class="d-flex justify-content-center">
                                <h6> Desde <?php echo e("$" . number_format($productoSimilar->min_venta_prta, 2)); ?></h6>
                            </div>
                        </div>
                        <div class="card-footer  justify-content-between bg-light border text-center">
                            <a href="<?php echo e(route('detalle.producto',$productoSimilar->codigo_prod)); ?>" class="btn btn-sm text-dark p-0"><i class="fas fa-eye color-principal-color mr-1"></i>Ver Detalles</a>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>
    <!-- CONTENIDO FIN -->
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const stars = document.querySelectorAll('#rating-stars .fa-star');
            const ratingInput = document.getElementById('rating');
            stars.forEach(star => {
                star.addEventListener('click', function () {
                    const rating = this.getAttribute('data-rating');
                    ratingInput.value = rating;
                    updateStars(rating);
                });
            });
            function updateStars(rating) {
                stars.forEach(star => {
                    if (star.getAttribute('data-rating') <= rating) {
                        star.classList.remove('far');
                        star.classList.add('fas');
                    } else {
                        star.classList.remove('fas');
                        star.classList.add('far');
                    }
                });
            }
        });
    </script>
    <script>
        $('.talla').click(function() {
            var precio = parseFloat($(this).data('precio'));
            var codigo = $(this).data('codigo');
            $('#valor').text('$' + precio.toFixed(2));
            $('#valorInput').val(precio);
            $('#codigoInput').val(codigo);
        });
        $(document).ready(function() {
            $('.agregarCarrito').on('click', function() {
                var codigoProducto = $(this).data('producto');
                var talla = $('.talla:checked').data('codigo'); // Obtener el valor del atributo data-codigo del radio button seleccionado
                var color = $('.color:checked').val(); // Obtener el valor del radio button de color seleccionado
                var cantidad = $('.cantidad').val();
                var csrfToken = $('#csrfToken').data('token');
                if (!cantidad && cantidad <= 0) {
                    Swal.fire({
                        title: '¡Error!',
                        text: 'Selecciona una talla',
                        icon: 'error',
                        confirmButtonText: 'OK'
                    });
                    return;
                }
                <?php if($conteoTallas >= 1): ?>
                    if (!talla) {
                        Swal.fire({
                            title: '¡Error!',
                            text: 'Selecciona una talla',
                            icon: 'error',
                            confirmButtonText: 'OK'
                        });
                        return;
                    }
                <?php endif; ?>
                <?php if($coloresConteo >= 1): ?>
                    if (!color) {
                        Swal.fire({
                            title: '¡Error!',
                            text: 'Selecciona una talla',
                            icon: 'error',
                            confirmButtonText: 'OK'
                        });
                        return;
                    }
                <?php endif; ?>



                var datos = {
                    talla: talla,
                    color: color,
                    cantidad: cantidad,
                    _token:  csrfToken
                };
                // Enviar los datos por POST a una ruta específica
                $.post('/carrito/agregar/'+ codigoProducto, datos, function(response) {
                    $('.totalProds').text(response.totalProds);
                    Swal.fire({
                        title: 'Éxito',
                        text: response.message,
                        icon: 'success',
                        confirmButtonText: 'OK'
                    });
                }).fail(function(jqXHR, textStatus, errorThrown) {
                    // Manejar el error en caso de que la solicitud falle
                    console.error('Error al enviar la solicitud:', errorThrown);
                });
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('tienda/layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\tienda\resources\views/tienda/detalle_producto.blade.php ENDPATH**/ ?>