<?php
$VerEditor = auth()->user()->can('Empresa - Visor') || auth()->user()->can('Empresa - Editor')
?>
<?php if($VerEditor): ?>

<?php $__env->startSection('tituloModulo', 'DATOS DE LA EMPRESA'); ?>
<?php $__env->startSection('contenido'); ?>
    <style>
        .costo-fijo-container,
        .paqueteria-container {
            display: none;

        }
    </style>
<form action="<?php echo e(route('datos_empresa.update')); ?>" method="POST" enctype="multipart/form-data">
    <?php echo csrf_field(); ?>
    <?php echo method_field('put'); ?>
    <div class="card">
        <div class="card-body">
            <h5 class="card-title">Datos de la empresa</h5>
            <div class="row">
                <div class="col-md-12 col-12 text-center">
                    <?php if($datos->logo_config): ?>
                    <img src="<?php echo e(asset('assets/img/logos/' . $datos->logo_config )); ?>" alt="logo" width="250" >
                    <?php else: ?>
                    <img src="<?php echo asset('assets/img/logos/logo.png'); ?>" alt="logo" width="250" >
                    <?php endif; ?>
                    <input class="form-control mt-2" type="file" name="logo">
                </div>
                <div class="col-md-6 col-12">
                    <label class="control-label is-required">Nombre del responsable</label>
                    <input class="form-control" type="text" name="nombre" value="<?php echo e($datos->nombre_config); ?>" required>
                </div>
                <div class="col-md-6 col-12">
                    <label class="control-label is-required">Nombre de la empresa</label>
                    <input class="form-control" type="text" name="empresa" value="<?php echo e($datos->empresa_config); ?>" required>
                </div>
                <div class="col-md-12 col-12">
                    <label class="control-label">RFC</label>
                    <input class="form-control" type="text" name="rfc" value="<?php echo e($datos->rfc_config); ?>">
                </div>
                <div class="col-md-12 col-12">
                    <label class="control-label">Código Postal</label>
                    <input class="form-control" type="text" name="codigo_postal" value="<?php echo e($datos->codigo_postal_config); ?>" >
                </div>
                <div class="col-md-6 col-12">
                    <label class="control-label">Teléfono</label>
                    <input class="form-control" type="text" name="telefono" value="<?php echo e($datos->telefono_config); ?>">
                </div>
                <div class="col-md-6 col-12">
                    <label class="control-label">Email</label>
                    <input class="form-control" type="email" name="email" value="<?php echo e($datos->email_config); ?>">
                </div>
                <div class="col-md-6 col-12">
                    <label class="control-label">Provincia o Estado</label>
                    <input class="form-control" type="text" name="provincia" value="<?php echo e($datos->provincia_config); ?>">
                </div>
                <div class="col-md-6 col-12">
                    <label class="control-label">Ciudad / Municipio / Delegación</label>
                    <input class="form-control" type="text" name="ciudad" value="<?php echo e($datos->ciudad_config); ?>">
                </div>
                <div class="col-md-12 col-12">
                    <label class="control-label">Dirección</label>
                    <input class="form-control" type="text" name="direccion" value="<?php echo e($datos->direccion_config); ?>">
                </div>
                <div class="col-md-12 col-12">
                    <label class="control-label">Color Principal</label>
                    <input class="form-control" type="color" name="color_principal"
                        value="<?php echo e($datos->color_pricipal_config); ?>">
                </div>
                <div class="col-md-12 col-12">
                    <label class="control-label">Mensaje Footer</label>
                    <input class="form-control" type="text" name="mensaje_footer"
                        value="<?php echo e($datos->mensaje_footer_config); ?>">
                </div>
                <div class="col-md-12 col-12">
                    <label class="control-label">Pasarela de pagos</label>
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" id="mercadoPago" name="mercadoPago" value="1"  <?php if($datos->mercado_pago_config): ?> checked  <?php endif; ?>>
                        <label class="form-check-label" for="mercadoPago">
                            <img alt="" src="<?php echo asset('assets/store/img/iconoMercadopago.png'); ?>"
                            width="30px"> Mercado Pago
                        </label>
                    </div>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="paypal" name="paypal" value="1" <?php if($datos->paypal_config): ?> checked  <?php endif; ?>>
                            <label class="form-check-label" for="paypal">
                                <img alt="" src="<?php echo asset('assets/store/img/paypalv2.png'); ?>"
                                        width="30px"> Paypal
                            </label>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-body">
            <h5 class="card-title">Datos de envío</h5>
            <div class="row">
                <div class="col-md-6 col-12">
                    <label class="control-label is-required">¿Deseas fijar un costo fijo de envió o por paquetería?</label>
                    <select class="form-select" aria-label="Default select example" name="envio" id="envio" required>
                        <?php if($datos->envio_config): ?>
                        <option value="<?php echo e($datos->envio_config); ?>"><?php echo e($datos->envio_config); ?></option>
                        <?php else: ?>
                        <option value="">Seleccione una opción</option>
                        <?php endif; ?>
                        <option value="Costo Fijo">Costo Fijo</option>
                        <option value="Por Paqueteria">Por Paqueteria</option>
                    </select>
                </div>
                <div class="col-md-6 col-12 costo-fijo-container" id="costo-fijo-container">
                    <label class="control-label is-required">Costo de envió fijo</label>
                    <input id="input-currency" class="form-control input-mask text-left importe"
                        data-inputmask="'alias': 'numeric', 'groupSeparator': ',', 'digits': 2, 'digitsOptional': false, 'prefix': '$ ', 'placeholder': '0'"
                        name="costo" id="costo"  value="<?php echo e($datos->costo_envio_config); ?>">
                </div>
                <div class="col-md-6 col-12 paqueteria-container" id="paqueteria-container">
                    <label class="control-label is-required">Paquetería</label>
                    <select class="form-select" aria-label="Default select example" name="paqueteria" id="paqueteria">
                        <option value="<?php echo e($datos->paqueteria_envio_config); ?>"><?php echo e($datos->paqueteria_envio_config); ?></option>
                    <?php $__currentLoopData = $carriers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $carrier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($carrier['name']); ?>"><?php echo e($carrier['name']); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-md-6 col-12 paqueteria-container" id="peso-container">
                    <label class="control-label is-required">Peso en KG</label>
                    <input id="input-currency" class="form-control input-mask text-left importe"
                        data-inputmask="'alias': 'numeric', 'groupSeparator': ',', 'digits': 0, 'digitsOptional': false, 'suffix': ' kg', 'placeholder': '0'"
                        name="peso" id="peso"  value="<?php echo e($datos->weight_config); ?>">
                </div>
                <div class="col-md-6 col-12 paqueteria-container" id="alto-container">
                    <label class="control-label is-required">Altura en CM</label>
                    <input id="input-currency" class="form-control input-mask text-left importe"
                        data-inputmask="'alias': 'numeric', 'groupSeparator': ',', 'digits': 0, 'digitsOptional': false, 'suffix': ' cm', 'placeholder': '0'"
                        name="altura" id="altura"  value="<?php echo e($datos->height_config); ?>">
                </div>
                <div class="col-md-6 col-12 paqueteria-container" id="ancho-container">
                    <label class="control-label is-required">Ancho en CM</label>
                    <input id="input-currency" class="form-control input-mask text-left importe"
                        data-inputmask="'alias': 'numeric', 'groupSeparator': ',', 'digits': 0, 'digitsOptional': false, 'suffix': ' cm', 'placeholder': '0'"
                        name="ancho" id="ancho"  value="<?php echo e($datos->width_config); ?>">
                </div>
                <div class="col-md-6 col-12 paqueteria-container" id="longitud-container">
                    <label class="control-label is-required">Longitud en CM</label>
                    <input id="input-currency" class="form-control input-mask text-left importe"
                        data-inputmask="'alias': 'numeric', 'groupSeparator': ',', 'digits': 0, 'digitsOptional': false, 'suffix': ' cm', 'placeholder': '0'"
                        name="longitud" id="longitud"  value="<?php echo e($datos->length_config); ?>">
                </div>
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-body">
            <h5 class="card-title">Redes sociales</h5>
            <div class="row">
                <div class="col-md-6 col-12">
                    <label class="control-label is-required">Facebook</label>
                    <input class="form-control" type="text" name="facebook" value="<?php echo e($datos->facebook_config); ?>">
                </div>
                <div class="col-md-6 col-12">
                    <label class="control-label">Instagrama</label>
                    <input class="form-control" type="text" name="instagram" value="<?php echo e($datos->instagram_config); ?>">
                </div>
                <div class="col-md-6 col-12">
                    <label class="control-label is-required">Youtube</label>
                    <input class="form-control" type="text" name="youtube" value="<?php echo e($datos->youtube_config); ?>">
                </div>
                <div class="col-md-6 col-12">
                    <label class="control-label">TikTok</label>
                    <input class="form-control" type="text" name="tiktok" value="<?php echo e($datos->tiktok_config); ?>">
                </div>
            </div>
        </div>
    </div>
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Empresa - Editor')): ?>
    <button type="submit" class="btn btn-outline-success"><i class="bx bx-save"></i> Guardar</button>
    <?php endif; ?>
    <div class="card mt-2">
        <div class="card-body">
            <h5 class="card-title">Banners</h5>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Empresa - Editor')): ?>
            <button type="button" class="btn btn-success mt-3" data-bs-toggle="modal" data-bs-target="#crearBanner">
                <i class="bx bxs-folder-plus"></i> Agregar Banner
            </button>
            <?php endif; ?>
            <div id="carouselExampleControls" class="carousel slide mt-2" data-bs-ride="carousel">
                <div class="carousel-inner">
                    <?php $__currentLoopData = $banners; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $banner): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="carousel-item active">
                        <img src="<?php echo asset('assets/store/img/banners/' . $banner->imagen_bann ); ?>" class="d-block w-100" alt="...">
                        <div class="carousel-caption d-none d-md-block">
                            <h5><?php echo e($banner->titulo_bann); ?></h5>
                            <p><?php echo e($banner->subtitulo_bann); ?></p>
                            <?php if($banner->url_bann): ?>
                            <a href="<?php echo e($banner->url_bann); ?>" class="btn btn-light py-2 px-3">Ver más</a>
                            <?php endif; ?>
                            <a href="<?php echo e(route('datos_empresa.banner.delete',$banner->codigo_bann )); ?>" class="btn btn-light py-2 px-3"><i class="bx  bxs-trash"></i> Eliminar</a>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <button class="carousel-control-prev" type="button" data-bs-target="#carouselExampleControls"
                    data-bs-slide="prev">
                    <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                    <span class="visually-hidden">Previous</span>
                </button>
                <button class="carousel-control-next" type="button" data-bs-target="#carouselExampleControls"
                    data-bs-slide="next">
                    <span class="carousel-control-next-icon" aria-hidden="true"></span>
                    <span class="visually-hidden">Next</span>
                </button>
            </div>
        </div>
    </div>
</form>
<div class="modal fade" id="crearBanner" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Agregar Banner</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="<?php echo e(route('datos_empresa.banner.store')); ?>" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-12 col-12">
                        <label class="control-label is-required">Imagen</label>
                        <input class="form-control" type="file" name="imagen" required>
                    </div>
                    <div class="col-md-12 col-12">
                        <label class="control-label">Titlulo</label>
                        <input class="form-control" type="text" name="titulo">
                    </div>
                    <div class="col-md-12 col-12">
                        <label class="control-label">Subtitulo</label>
                        <input class="form-control" type="text" name="subtitulo">
                    </div>
                    <div class="col-md-12 col-12">
                        <label class="control-label">URL</label>
                        <input class="form-control" type="text" name="url">
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="submit" class="btn btn-success"><i class="bx bx-save"></i> Guardar</button>
                <button type="button" class="btn btn-danger" data-bs-dismiss="modal"><i class="bx  bxs-x-circle"></i> Cerrar</button>
            </div>
            </form>
        </div>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        var envioSelect = document.getElementById('envio');
        var costoFijoContainer = document.getElementById('costo-fijo-container');
        var paqueteriaContainer = document.getElementById('paqueteria-container');
        var pesoContainer = document.getElementById('peso-container');
        var altoContainer = document.getElementById('alto-container');
        var anchoContainer = document.getElementById('ancho-container');
        var longitudContainer = document.getElementById('longitud-container');

        envioSelect.addEventListener('change', function() {
            if (envioSelect.value === 'Costo Fijo') {
                costoFijoContainer.style.display = 'block';
                paqueteriaContainer.style.display = 'none';
                pesoContainer.style.display = 'none';
                altoContainer.style.display = 'none';
                anchoContainer.style.display = 'none';
                longitudContainer.style.display = 'none';
            } else if (envioSelect.value === 'Por Paqueteria') {
                costoFijoContainer.style.display = 'none';
                paqueteriaContainer.style.display = 'block';
                pesoContainer.style.display = 'block';
                altoContainer.style.display = 'block';
                anchoContainer.style.display = 'block';
                longitudContainer.style.display = 'block';


            } else {
                costoFijoContainer.style.display = 'none';
                paqueteriaContainer.style.display = 'none';
                pesoContainer.style.display = 'none';
                altoContainer.style.display = 'none';
                anchoContainer.style.display = 'none';
                longitudContainer.style.display = 'none';
            }
        });

        // Trigger change event on page load to ensure correct fields are displayed
        envioSelect.dispatchEvent(new Event('change'));
    });

</script>

<?php $__env->stopSection(); ?>
<?php endif; ?>

<?php echo $__env->make('layouts/app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\tiendablogauto\resources\views/datos_empresa/index.blade.php ENDPATH**/ ?>