
<?php $__env->startSection('tituloModulo','DASHBOARD'); ?>
<?php $__env->startSection('contenido'); ?>
<?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'Cliente')): ?>
<section class="section dashboard">
    <div class="row">
        <div class="col-xxl-4 col-md-6">
            <div class="card info-card sales-card">
                <div class="card-body">
                <h5 class="card-title">Productos Comprados <span>| <?php echo e($mesActual); ?></span></h5>
                <div class="d-flex align-items-center">
                    <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                        <i class="bi bi-cart"></i>
                    </div>
                    <div class="ps-3">
                        <h6><?php echo e($conteoProductos); ?></h6>
                        <span class="text-success small pt-1 fw-bold"></span> <span class="text-muted small pt-2 ps-1">Productos Entregados</span>
                    </div>
                </div>
                </div>
            </div>
        </div>
        <div class="col-xxl-4 col-md-6">
            <div class="card info-card revenue-card">
                <div class="card-body">
                <h5 class="card-title">Compras <span>| <?php echo e($mesActual); ?></span></h5>
                <div class="d-flex align-items-center">
                    <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                        <i class="bi bi-currency-dollar"></i>
                    </div>
                    <div class="ps-3">
                        <h6><?php echo e("$" . number_format($conteoCompras, 2)); ?></h6>
                        <span class="text-success small pt-1 fw-bold"></span> <span class="text-muted small pt-2 ps-1">Moneda Nacional MXM</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>
<?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'Administrador')): ?>
<section class="section dashboard">
    <div class="row">
        <div class="col-xxl-4 col-md-4 col-12">
            <div class="card info-card sales-card">
                <div class="card-body">
                <h5 class="card-title">Productos Vendidos <span>| <?php echo e($mesActual); ?></span></h5>
                <div class="d-flex align-items-center">
                    <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                        <i class="bi bi-cart"></i>
                    </div>
                    <div class="ps-3">
                        <h6><?php echo e($conteoProductos); ?></h6>
                        <span class="text-success small pt-1 fw-bold"></span> <span class="text-muted small pt-2 ps-1">Productos Entregados</span>
                    </div>
                </div>
                </div>
            </div>
        </div>
        <div class="col-xxl-4 col-md-4 col-12">
            <div class="card info-card revenue-card">
                <div class="card-body">
                <h5 class="card-title">Ventas <span>| <?php echo e($mesActual); ?></span></h5>
                <div class="d-flex align-items-center">
                    <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                        <i class="bi bi-currency-dollar"></i>
                    </div>
                    <div class="ps-3">
                        <h6><?php echo e("$" . number_format($conteoCompras, 2)); ?></h6>
                        <span class="text-success small pt-1 fw-bold"></span> <span class="text-muted small pt-2 ps-1">Moneda Nacional MXM</span>
                    </div>
                </div>
                </div>
            </div>
        </div>
        <div class="col-xxl-4 col-md-4 col-12">
            <div class="card info-card customers-card">
                <div class="card-body">
                    <h5 class="card-title">Clientes <span>| Año <?php echo e($anioActual); ?></span></h5>
                    <div class="d-flex align-items-center">
                        <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                        <i class="bi bi-people"></i>
                        </div>
                        <div class="ps-3">
                        <h6><?php echo e($clientes); ?></h6>
                        <span class="text-danger small pt-1 fw-bold"></span> <span class="text-muted small pt-2 ps-1">Clientes Registrados</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-lg-12 col-md-12 col-12">
            <div class="card">
                <div class="card-body">
                <h5 class="card-title">Ventas por mes | Año <?php echo e($anioActual); ?> </h5>
                <!-- Line Chart -->
                <canvas id="lineChart" style="max-height: 400px;"></canvas>
                    <script>
                    document.addEventListener("DOMContentLoaded", () => {
                    var labelsVentasMes = <?php echo e(Js::from($labelsVentasMes)); ?>;
                    var dataConteoVisitasMes = <?php echo e(Js::from($dataConteoVisitasMes)); ?>;
                    new Chart(document.querySelector('#lineChart'), {
                        type: 'line',
                        data: {
                            labels: labelsVentasMes,
                            datasets: [{
                                label: 'Ventas por mes en el año <?php echo e($anioActual); ?>',
                                data: dataConteoVisitasMes,
                                backgroundColor: [
                                'rgba(255, 10, 10, 0.2)',
                                'rgba(255, 121, 10, 0.2)',
                                'rgba(255, 228, 0, 0.2)',
                                'rgba(197, 255, 0, 0.2)',
                                'rgba(53, 194, 5, 0.2)',
                                ],
                                borderColor: [
                                'rgba(255, 10, 10, 1)',
                                'rgba(255, 121, 10, 1)',
                                'rgba(2255, 228, 0, 1)',
                                'rgba(197, 255, 0, 1)',
                                'rgba(53, 194, 0, 1)',
                                ],
                                hoverOffset: 4
                            }]
                        },
                        options: { scales:  { y:    {   beginAtZero: true  }    }    }
                        });
                    });
                    </script>
                </div>
            </div>
        </div>
    </div>
</section>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\tienda\resources\views/home.blade.php ENDPATH**/ ?>