<?php
$VerEditor = auth()->user()->can('Direcciones - Visor') || auth()->user()->can('Direcciones - Editor')
?>
<?php if($VerEditor): ?>

<?php $__env->startSection('tituloModulo', 'DIRECCIONES ADICIONALES'); ?>
<?php $__env->startSection('contenido'); ?>
<div class="card">
    <div class="card-body">
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Direcciones - Editor')): ?>
            <?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'Cliente')): ?>
            <button type="button" class="btn btn-success mt-3" data-bs-toggle="modal" data-bs-target="#crear">
                <i class="bx bxs-folder-plus"></i> Agregar dirección
            </button>
            <div class="modal fade" id="crear" tabindex="-1">
                <div class="modal-dialog modal-lg">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">Agregar dirección</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <form action="<?php echo e(route('direcciones.store')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                        <div class="modal-body">
                            <div class="row">
                                <div class="col-md-12 col-12">
                                    <label class="control-label is-required">Dirección</label>
                                    <input class="form-control" type="text" name="direccion" required>
                                </div>
                                <div class="col-md-12 col-12">
                                    <label class="control-label is-required">Referencia</label>
                                    <textarea name="referencia" class="form-control" required></textarea>
                                </div>
                                <div class="col-md-6 col-12">
                                    <label class="control-label is-required">Estado</label>
                                    <select class="form-select" aria-label="Default select example" name="estado" required>
                                        <option value="">Seleccione une Estado</option>
                                        <?php $__currentLoopData = $estadosRepublica; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $estadoRepublica): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($estadoRepublica->id); ?>"><?php echo e($estadoRepublica->nombre_edo); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="col-md-6 col-12">
                                    <label class="control-label is-required">Ciudad</label>
                                    <input class="form-control" type="text" name="ciudad" required>
                                </div>
                                <div class="col-md-6 col-12">
                                    <label class="control-label is-required">Código Postal</label>
                                    <input class="form-control" type="text" name="cp" required>
                                </div>
                                <div class="col-md-6 col-12">
                                    <label class="control-label is-required">País</label>
                                    <input class="form-control" type="text" name="pais" required>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-success"><i class="bx bx-save"></i> Guardar</button>
                            <button type="button" class="btn btn-danger" data-bs-dismiss="modal"><i class="bx  bxs-x-circle"></i> Cerrar</button>
                        </div>
                        </form>
                    </div>
                </div>
            </div>
            <?php endif; ?>
        <?php endif; ?>
        <div class="datatable-wrapper datatable-loading no-footer sortable searchable fixed-columns">
            <div class="datatable-container">
                <table class="table datatable datatable-table">
                    <thead>
                        <tr class="text">
                            <?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'Administrador')): ?>
                            <th data-sortable="true" scope="col">CLIENTE</th>
                            <?php endif; ?>
                            <th data-sortable="true" scope="col">DIRECCIÓN</th>
                            <th data-sortable="true" scope="col">REFERENCÍA</th>
                            <th data-sortable="true" scope="col">CIUDAD</th>
                            <th data-sortable="true" scope="col">ESTADO</th>
                            <th data-sortable="true" scope="col">PAÍS</th>
                            <th data-sortable="true" scope="col">CÓDIGO POSTAL</th>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Direcciones - Editor')): ?>
                                <?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'Cliente')): ?>
                            <th data-sortable="true" scope="col">ACCIÓN</th>
                                <?php endif; ?>
                            <?php endif; ?>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $datos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'Administrador')): ?>
                            <td data-title="CLIENTE"><?php echo e($item->name); ?></td>
                            <?php endif; ?>
                            <td data-title="DIRECCIÓN"><?php echo e($item->direccion_dire); ?></td>
                            <td data-title="REFERENCÍA"><?php echo e($item->referencia_dire); ?></td>
                            <td data-title="CIUDAD"><?php echo e($item->ciudad_dire); ?></td>
                            <td data-title="ESTADO"><?php echo e($item->nombre_edo); ?></td>
                            <td data-title="ESTPAÍSADO"><?php echo e($item->pais_dire); ?></td>
                            <td data-title="CÓDIGO POSTAL"><?php echo e($item->codigo_postal_dire); ?></td>
                            </td>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Direcciones - Editor')): ?>
                                <?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'Cliente')): ?>
                            <td data-title="ACCIÓN">
                                <div class="btn-group">
                                    <button type="button" class="btn btn-outline-primary dropdown-toggle btnTabla"
                                        data-bs-toggle="dropdown" aria-expanded="false">Acción <i
                                            class="mdi mdi-chevron-down"></i></button>
                                    <div class="dropdown-menu">
                                        <button type="button" class="btn btn-outline-success mt-2 dropdown-item" data-bs-toggle="modal" data-bs-target="#editar<?php echo e($item->codigo_dire); ?>">
                                            <i class="bx bxs-edit"></i> Editar
                                        </button>
                                        <form action="<?php echo e(route('direcciones.delete', $item->codigo_dire)); ?>" method="POST" enctype="multipart/form-data" class="form-delete">
                                            <?php echo csrf_field(); ?>
                                            <button class="dropdown-item"   type="submit" id="btn" >
                                                <i class="bx  bxs-trash"></i> Eliminar
                                            </button>
                                        </form>
                                    </div>
                                </div>
                            </td>
                                <?php endif; ?>
                            <?php endif; ?>
                        </tr>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Direcciones - Editor')): ?>
                        <div class="modal fade" id="editar<?php echo e($item->codigo_dire); ?>" tabindex="-1">
                            <div class="modal-dialog modal-lg">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title">Editar dirección</h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                    </div>
                                    <form action="<?php echo e(route('direcciones.update',  $item->codigo_dire)); ?>" method="POST">
                                        <?php echo csrf_field(); ?>
                                    <div class="modal-body">
                                        <div class="row">
                                            <div class="col-md-12 col-12">
                                                <label class="control-label is-required">Dirección</label>
                                                <input class="form-control" type="text" value="<?php echo e($item->direccion_dire); ?>" name="direccion" required>
                                            </div>
                                            <div class="col-md-12 col-12">
                                                <label class="control-label is-required">Referencia</label>
                                                <textarea name="referencia" class="form-control" required> <?php echo e($item->referencia_dire); ?></textarea>
                                            </div>
                                            <div class="col-md-6 col-12">
                                                <label class="control-label is-required">Estado</label>
                                                <select class="form-select" aria-label="Default select example" name="estado" required>
                                                    <option value="<?php echo e($item->estado_dire); ?>"><?php echo e($item->nombre_edo); ?></option>
                                                    <?php $__currentLoopData = $estadosRepublica; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $estadoRepublica): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($estadoRepublica->id); ?>"><?php echo e($estadoRepublica->nombre_edo); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                            <div class="col-md-6 col-12">
                                                <label class="control-label is-required">Ciudad</label>
                                                <input class="form-control" type="text" value="<?php echo e($item->ciudad_dire); ?>" name="ciudad" required>
                                            </div>
                                            <div class="col-md-6 col-12">
                                                <label class="control-label is-required">Código Postal</label>
                                                <input class="form-control" type="text" value="<?php echo e($item->codigo_postal_dire); ?>" name="cp" required>
                                            </div>
                                            <div class="col-md-6 col-12">
                                                <label class="control-label is-required">País</label>
                                                <input class="form-control" type="text" value="<?php echo e($item->pais_dire); ?>" name="pais" required>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="submit" class="btn btn-success"><i class="bx bx-save"></i> Actualizar</button>
                                        <button type="button" class="btn btn-danger" data-bs-dismiss="modal"><i class="bx  bxs-x-circle"></i> Cerrar</button>
                                    </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                        <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
            <div class="datatable-bottom">
                <nav class="datatable-pagination">
                    <ul class="datatable-pagination-list"></ul>
                </nav>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php endif; ?>

<?php echo $__env->make('layouts/app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\keninails\resources\views/direcciones/index.blade.php ENDPATH**/ ?>