<?php
$VerEditor = auth()->user()->can('Eventos - Visor') || auth()->user()->can('Eventos - Editor')
?>
<?php if($VerEditor): ?>

<?php $__env->startSection('tituloModulo', 'EVENTOS'); ?>
<?php $__env->startSection('contenido'); ?>
<div class="card">
    <div class="card-body">
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Eventos - Editor')): ?>
        <button type="button" class="btn btn-success mt-3" data-bs-toggle="modal" data-bs-target="#crear">
            <i class="bx bxs-folder-plus"></i> Agregar evento
        </button>
        <div class="modal fade" id="crear" tabindex="-1">
            <div class="modal-dialog modal-xl">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Agregar evento</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form action="<?php echo e(route('eventos.store')); ?>" method="POST" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <label class="control-label is-required">Nombre del evento</label>
                        <input class="form-control" type="text" name="nombre" required>
                        <label class="control-label is-required">Fecha de evento</label>
                        <input class="form-control" type="date" name="fecha" required>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success"><i class="bx bx-save"></i> Guardar</button>
                        <button type="button" class="btn btn-danger" data-bs-dismiss="modal"><i class="bx  bxs-x-circle"></i> Cerrar</button>
                    </div>
                    </form>
                </div>
            </div>
        </div>
        <?php endif; ?>
        <div class="datatable-wrapper datatable-loading no-footer sortable searchable fixed-columns">
            <div class="datatable-container">
                <table class="table datatable datatable-table">
                    <thead>
                        <tr class="text">
                            <th data-sortable="true" scope="col">IMAGEN</th>
                            <th data-sortable="true" scope="col">NOMBRE</th>
                            <th data-sortable="true" scope="col">FECHA DEL EVENTO</th>
                            <th data-sortable="true" scope="col">ESTATUS</th>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Eventos - Editor')): ?>
                            <th data-sortable="true" scope="col">ACCIÓN</th>
                            <?php endif; ?>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $datos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td data-title="IMAGEN"><?php if($item->imagen_even): ?>
                                <img src="<?php echo e(asset('assets/img/eventos/' . $item->imagen_even)); ?>" alt="Evento" width="50" >
                                <?php else: ?>
                                <img src="<?php echo asset('assets/img/eventos.png'); ?>" alt="Profile" width="50" height="50" >
                                <?php endif; ?></td>
                            <td data-title="NOMBRE"><?php echo e($item->nombre_even); ?></td>
                            <td data-title="FECHA DEL EVENTO"><?php echo e(date("d/m/Y", strtotime($item->fecha_even))); ?></td>
                            <td data-title="ESTATUS">
                                <?php if($item->estatus_even == 'Activo'): ?>
                                    <span class="badge bg-success"><?php echo e($item->estatus_even); ?></span>
                                <?php endif; ?>
                                <?php if($item->estatus_even == 'Inactivo'): ?>
                                    <span class="badge bg-danger"><?php echo e($item->estatus_even); ?></span>
                                <?php endif; ?>
                            </td>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Eventos - Editor')): ?>
                            <td data-title="ACCIÓN">
                                <div class="btn-group">
                                    <button type="button" class="btn btn-outline-primary dropdown-toggle btnTabla"
                                        data-bs-toggle="dropdown" aria-expanded="false">Acción <i
                                            class="mdi mdi-chevron-down"></i></button>
                                    <div class="dropdown-menu">
                                        <form action="<?php echo e(route('eventos.dats', $item->codigo_even)); ?>" method="GET">
                                            <button class="dropdown-item"   type="submit" id="btn" >
                                                <i class="bx bxs-edit"></i> Editar
                                            </button>
                                        </form>
                                        <form action="<?php echo e(route('eventos.activate', $item->codigo_even)); ?>" method="POST" enctype="multipart/form-data" class="form-activar">
                                            <?php echo csrf_field(); ?>
                                            <button class="dropdown-item"   type="submit" id="btn" >
                                                <i class="bx bx-check-circle"></i> Activar
                                            </button>
                                        </form>
                                        <form action="<?php echo e(route('eventos.inactivate', $item->codigo_even)); ?>" method="POST" enctype="multipart/form-data" class="form-inactivar">
                                            <?php echo csrf_field(); ?>
                                            <button class="dropdown-item"   type="submit" id="btn" >
                                                <i class="bx bx-x-circle"></i> Inactivar
                                            </button>
                                        </form>
                                        <form action="<?php echo e(route('eventos.delete', $item->codigo_even)); ?>" method="POST" enctype="multipart/form-data" class="form-delete">
                                            <?php echo csrf_field(); ?>
                                            <button class="dropdown-item"   type="submit" id="btn" >
                                                <i class="bx  bxs-trash"></i> Eliminar
                                            </button>
                                        </form>
                                    </div>
                                </div>
                            </td>
                            <?php endif; ?>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
            <div class="datatable-bottom">
                <nav class="datatable-pagination">
                    <ul class="datatable-pagination-list"></ul>
                </nav>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php endif; ?>


<?php echo $__env->make('layouts/app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\tiendablogauto\resources\views/eventos/index.blade.php ENDPATH**/ ?>