<?php
$VerEditor = auth()->user()->can('Productos - Visor') || auth()->user()->can('Productos - Editor')
?>
<?php if($VerEditor): ?>

<?php $__env->startSection('tituloModulo', 'PRODUCTOS'); ?>
<?php $__env->startSection('contenido'); ?>
<div class="card">
    <div class="card-body">
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Productos - Editor')): ?>
        <button type="button" class="btn btn-success mt-3" data-bs-toggle="modal" data-bs-target="#crear">
            <i class="bx bxs-folder-plus"></i> Agregar producto
        </button>
        <div class="modal fade" id="crear" tabindex="-1">
            <div class="modal-dialog modal-xl">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Agregar producto</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form action="<?php echo e(route('productos.store')); ?>" method="POST" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <label class="control-label is-required">SKU</label>
                        <input class="form-control" type="text" name="sku" required>
                        <label class="control-label is-required">Nombre del producto</label>
                        <input class="form-control" type="text" name="nombre" required>
                        <label class="control-label is-required">Categoría de producto</label>
                        <select class="form-select "  name="categoria" id="categoria" required>
                            <option value="">Seleccione la categoría del producto</option>
                            <?php $__currentLoopData = $categorias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $categoria): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($categoria->codigo_prca); ?>"><?php echo e($categoria->nombre_prca); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <label class="control-label is-required">Subcategoría de producto</label>
                        <select class="form-select "  name="subcategoria" id="subcategoria" required>
                            <option value="">Seleccione la categoría del producto</option>
                            <?php $__currentLoopData = $subcategorias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subcategoria): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($subcategoria->codigo_prsu); ?>"><?php echo e($subcategoria->nombre_prsu); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success"><i class="bx bx-save"></i> Guardar</button>
                        <button type="button" class="btn btn-danger" data-bs-dismiss="modal"><i class="bx  bxs-x-circle"></i> Cerrar</button>
                    </div>
                    </form>
                </div>
            </div>
        </div>
        <?php endif; ?>
        <div class="datatable-wrapper datatable-loading no-footer sortable searchable fixed-columns">
            <div class="datatable-container">
                <table class="table datatable datatable-table">
                    <thead>
                        <tr class="text">
                            <th data-sortable="true" scope="col">IMAGEN</th>
                            <th data-sortable="true" scope="col">SKU</th>
                            <th data-sortable="true" scope="col">NOMBRE</th>
                            <th data-sortable="true" scope="col">CATEGORÍA</th>
                            <th data-sortable="true" scope="col">SUBCATEGORÍA</th>
                            <th data-sortable="true" scope="col">ESTATUS</th>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Productos - Editor')): ?>
                            <th data-sortable="true" scope="col">ACCIÓN</th>
                            <?php endif; ?>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $datos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td data-title="IMAGEN"><?php if($item->imagen_principal_prod): ?>
                                <img src="<?php echo e(asset('assets/img/productos/' . $item->imagen_principal_prod)); ?>" alt="Producto" width="50" >
                                <?php else: ?>
                                <img src="<?php echo asset('assets/img/products.png'); ?>" alt="Profile" width="50" height="50" >
                                <?php endif; ?></td>
                            <td data-title="SKU"><?php echo e($item->sku_prod); ?></td>
                            <td data-title="NOMBRE"><?php echo e($item->nombre_prod); ?></td>
                            <td data-title="CATEGORÍA"><?php echo e($item->nombre_prca); ?></td>
                            <td data-title="SUBCATEGORÍA"><?php echo e($item->nombre_prsu); ?></td>
                            <td data-title="ESTATUS">
                                <?php if($item->estatus_prod == 'Activo'): ?>
                                    <span class="badge bg-success"><?php echo e($item->estatus_prod); ?></span>
                                <?php endif; ?>
                                <?php if($item->estatus_prod == 'Inactivo'): ?>
                                    <span class="badge bg-danger"><?php echo e($item->estatus_prod); ?></span>
                                <?php endif; ?>
                            </td>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Productos - Editor')): ?>
                            <td data-title="ACCIÓN">
                                <div class="btn-group">
                                    <button type="button" class="btn btn-outline-primary dropdown-toggle btnTabla"
                                        data-bs-toggle="dropdown" aria-expanded="false">Acción <i
                                            class="mdi mdi-chevron-down"></i></button>
                                    <div class="dropdown-menu">
                                        <form action="<?php echo e(route('productos.dats', $item->codigo_prod)); ?>" method="GET">
                                            <button class="dropdown-item"   type="submit" id="btn" >
                                                <i class="bx bxs-edit"></i> Editar
                                            </button>
                                        </form>
                                        <form action="<?php echo e(route('productos.activate', $item->codigo_prod)); ?>" method="POST" enctype="multipart/form-data" class="form-activar">
                                            <?php echo csrf_field(); ?>
                                            <button class="dropdown-item"   type="submit" id="btn" >
                                                <i class="bx bx-check-circle"></i> Activar
                                            </button>
                                        </form>
                                        <form action="<?php echo e(route('productos.inactivate', $item->codigo_prod)); ?>" method="POST" enctype="multipart/form-data" class="form-inactivar">
                                            <?php echo csrf_field(); ?>
                                            <button class="dropdown-item"   type="submit" id="btn" >
                                                <i class="bx bx-x-circle"></i> Inactivar
                                            </button>
                                        </form>
                                        <form action="<?php echo e(route('productos.delete', $item->codigo_prod)); ?>" method="POST" enctype="multipart/form-data" class="form-delete">
                                            <?php echo csrf_field(); ?>
                                            <button class="dropdown-item"   type="submit" id="btn" >
                                                <i class="bx  bxs-trash"></i> Eliminar
                                            </button>
                                        </form>
                                    </div>
                                </div>
                            </td>
                            <?php endif; ?>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
            <div class="datatable-bottom">
                <nav class="datatable-pagination">
                    <ul class="datatable-pagination-list"></ul>
                </nav>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php endif; ?>


<?php echo $__env->make('layouts/app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\keninails\resources\views/productos/index.blade.php ENDPATH**/ ?>