<?php
$VerEditor = auth()->user()->can('Eventos - Editor')
?>
<?php if($VerEditor): ?>

<?php $__env->startSection('tituloModulo', 'DATOS DEL EVENTO'); ?>
<?php $__env->startSection('contenido'); ?>
<div class="card">
    <div class="card-body">
        <form action="<?php echo e(route('eventos.update', $datos->codigo_even)); ?>" method="POST"  enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <div class="row mt-2">
                <div class="col-md-12 col-12 text-center">
                    <?php if($datos->imagen_even): ?>
                    <img src="<?php echo e(asset('assets/img/eventos/' . $datos->imagen_even)); ?>" alt="Evento" width="150" >
                    <?php else: ?>
                    <img src="<?php echo asset('assets/img/eventos/eventos.png'); ?>" alt="Evento" width="150" height="150" >
                    <?php endif; ?>
                </div>
                <div class="col-md-12 col-12">
                    <label class="control-label">Imagen principal</label>
                    <input class="form-control" name="imagenPrincipal"  type="file">
                </div>
                <div class="col-md-12 col-12">
                    <label class="control-label is-required">Nombre</label>
                    <input class="form-control" name="nombre" value="<?php echo e($datos->nombre_even); ?>"type="text" required>
                </div>
                <div class="col-md-12 col-12">
                    <label class="control-label is-required">Descripción larga</label>
                    <div id="descripcion"><?php echo $datos->decripcion_even; ?></div>
                    <textarea name="descripcion" style="display:none"><?php echo $datos->decripcion_even; ?></textarea>
                    <script>
                        ClassicEditor
                            .create( document.querySelector( '#descripcion' ) )
                            .then( descripcion => {
                                descripcion.model.document.on('change:data', () => {
                                    document.querySelector('textarea[name="descripcion"]').value = descripcion.getData();
                                });
                            })
                            .catch( error => {
                                console.error( error );
                            } );
                    </script>
                </div>
                <label class="control-label">Banner del Evento</label>
                <div class="col-md-12 col-12 text-center">
                    <?php if($datos->banner_even): ?>
                    <img src="<?php echo e(asset('assets/img/eventos/' . $datos->banner_even)); ?>" alt="Banner" width="450" >
                    <?php else: ?>
                    <img src="<?php echo asset('assets/img/eventos/eventosBanner.png'); ?>" alt="Banner" width="250" height="250" >
                    <?php endif; ?>
                </div>
                <div class="col-md-12 col-12 mt-2">
                    <input class="form-control" name="banner"  type="file">
                </div>
            </div>
            <button type="submit" class="btn btn-success mt-3" data-bs-toggle="modal" data-bs-target="#crear">
                <i class="bx  bxs-save"></i> Guardar
            </button>
        </form>
    </div>
</div>
<div class="card">
    <div class="card-body">
        <h5 class="card-title">Boletos</h5>
        <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#crearBoleto<?php echo e($datos->codigo_even); ?>">
            <i class="bx bxs-folder-plus"></i> Agregar boleto
        </button>
        <div class="datatable-wrapper datatable-loading no-footer sortable searchable fixed-columns">
            <div class="datatable-container">
                <table class="table datatable datatable-table">
                    <thead>
                        <tr class="text">
                            <th data-sortable="true" scope="col">NOMBRE</th>
                            <th data-sortable="true" scope="col">PRECIO</th>
                            <th data-sortable="true" scope="col">¿LLEVA STOCK?</th>
                            <th data-sortable="true" scope="col">NO. DE BOLETOS</th>
                            <th data-sortable="true" scope="col">ACCIÓN</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $boletos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $boleto): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td data-title="NOMBRE"><?php echo e($boleto->nombre_enbo); ?></td>
                            <td data-title="PRECIO"><?php echo e("$" . number_format($boleto->precio_enbo, 2)); ?></td>
                            <td data-title="¿LLEVA STOCK?"><?php if($boleto->stock_enbo == 1): ?> SI <?php else: ?> NO <?php endif; ?></td>
                            <td data-title="NO. DE BOLETOS"><?php echo e($boleto->nro_boletos_enbo); ?></td>
                            <td data-title="ACCIÓN">
                                <div class="btn-group">
                                    <button type="button" class="btn btn-outline-primary dropdown-toggle btnTabla"
                                        data-bs-toggle="dropdown" aria-expanded="false">Acción <i
                                            class="mdi mdi-chevron-down"></i></button>
                                    <div class="dropdown-menu">
                                        <button type="button" class="btn btn-outline-success mt-2 dropdown-item" data-bs-toggle="modal" data-bs-target="#editar<?php echo e($boleto->codigo_enbo); ?>">
                                            <i class="bx bxs-edit"></i> Editar
                                        </button>
                                        <form action="<?php echo e(route('eventos.delete.boletos', $boleto->codigo_enbo)); ?>" method="POST"  class="form-delete">
                                            <?php echo csrf_field(); ?>
                                            <button class="dropdown-item"   type="submit" id="btn" >
                                                <i class="bx  bxs-trash"></i> Eliminar
                                            </button>
                                        </form>
                                    </div>
                                </div>
                            </td>
                        </tr>
                        <div class="modal fade" id="editar<?php echo e($boleto->codigo_enbo); ?>" tabindex="-1">
                            <div class="modal-dialog modal-lg">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title">Editar Boleto</h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                    </div>
                                    <form action="<?php echo e(route('eventos.update.boletos', $boleto->codigo_enbo)); ?>" method="POST">
                                        <?php echo csrf_field(); ?>
                                        <div class="modal-body">
                                            <div class="form-group">
                                                <div class="row">
                                                    <div class="col-md-12 col-12">
                                                        <label class="control-label is-required">Nombre</label>
                                                        <input class="form-control" name="nombre" value="<?php echo e($boleto->nombre_enbo); ?>" type="text" required>
                                                    </div>
                                                    <div class="col-md-12 col-12">
                                                        <label class="control-label">Precio de venta</label>
                                                        <input id="input-currency" class="form-control input-mask text-left"
                                                            data-inputmask="'alias': 'numeric', 'groupSeparator': '', 'digits': 0, 'digitsOptional': false, 'prefix': '$ ', 'placeholder': '0'"
                                                            name="precio" value="<?php echo e($boleto->precio_enbo); ?>">
                                                    </div>
                                                    <div class="col-md-12 col-12">
                                                        <label class="control-label">Limitar a un número de boletos</label>
                                                        <div>
                                                            <input type="radio" name="limitarStock" id="limitarStockSi<?php echo e($boleto->codigo_enbo); ?>" value="1" <?php echo e($boleto->nro_boletos_enbo ? 'checked' : ''); ?>> Sí
                                                            <input type="radio" name="limitarStock" id="limitarStockNo<?php echo e($boleto->codigo_enbo); ?>" value="0" <?php echo e(!$boleto->nro_boletos_enbo ? 'checked' : ''); ?>> No
                                                        </div>
                                                    </div>
                                                    <div class="col-md-12 col-12" id="numeroBoletosContainer<?php echo e($boleto->codigo_enbo); ?>" style="display: <?php echo e($boleto->nro_boletos_enbo ? 'block' : 'none'); ?>;">
                                                        <label class="control-label">Número de boletos</label>
                                                        <input class="form-control" name="numeroBoletos" id="numeroBoletos<?php echo e($boleto->codigo_enbo); ?>" value="<?php echo e($boleto->nro_boletos_enbo); ?>" type="number" min="1">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="submit" class="btn btn-success"><i class="bx bx-save"></i> Actualizar</button>
                                            <button type="button" class="btn btn-danger" data-bs-dismiss="modal"><i class="bx  bxs-x-circle"></i> Cerrar</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>

                        <script>
                            document.addEventListener('DOMContentLoaded', function() {
                                const limitarStockSi = document.getElementById('limitarStockSi<?php echo e($boleto->codigo_enbo); ?>');
                                const limitarStockNo = document.getElementById('limitarStockNo<?php echo e($boleto->codigo_enbo); ?>');
                                const numeroBoletosContainer = document.getElementById('numeroBoletosContainer<?php echo e($boleto->codigo_enbo); ?>');

                                if (limitarStockSi && limitarStockNo && numeroBoletosContainer) {
                                    limitarStockSi.addEventListener('change', function() {
                                        if (this.checked) {
                                            numeroBoletosContainer.style.display = 'block';
                                        }
                                    });

                                    limitarStockNo.addEventListener('change', function() {
                                        if (this.checked) {
                                            numeroBoletosContainer.style.display = 'none';
                                        }
                                    });
                                }
                            });
                        </script>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
            <div class="datatable-bottom">
                <nav class="datatable-pagination">
                    <ul class="datatable-pagination-list"></ul>
                </nav>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="crearBoleto<?php echo e($datos->codigo_even); ?>" tabindex="-1">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Agregar datos del boleto</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="<?php echo e(route('eventos.store.boletos', $datos->codigo_even)); ?>" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <div class="form-group">
                        <div class="row">
                            <div class="col-md-12 col-12">
                                <label class="control-label is-required">Nombre</label>
                                <input class="form-control" name="nombre"  type="text" required>
                            </div>
                            <div class="col-md-12 col-12">
                                <label class="control-label">Precio de venta</label>
                                <input id="input-currency" class="form-control input-mask text-left"
                                    data-inputmask="'alias': 'numeric', 'groupSeparator': '', 'digits': 0, 'digitsOptional': false, 'prefix': '$ ', 'placeholder': '0'"
                                    name="precio">
                            </div>
                            <div class="col-md-12 col-12">
                                <label class="control-label">Limitar a un número de boletos</label>
                                <div>
                                    <input type="radio" name="limitarStock" id="limitarStockSi" value="1"> Sí
                                    <input type="radio" name="limitarStock" id="limitarStockNo" value="0" checked> No
                                </div>
                            </div>
                            <div class="col-md-12 col-12" id="numeroBoletosContainer" style="display: none;">
                                <label class="control-label">Número de boletos</label>
                                <input class="form-control" name="numeroBoletos" id="numeroBoletos" value="<?php echo e($datos->nro_boletos_enbo); ?>" type="number" min="1">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-success"><i class="bx bx-save"></i> Guardar</button>
                    <button type="button" class="btn btn-danger" data-bs-dismiss="modal"><i class="bx  bxs-x-circle"></i> Cerrar</button>
                </div>
            </form>
        </div>
    </div>
</div>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const limitarStockSi = document.getElementById('limitarStockSi');
        const limitarStockNo = document.getElementById('limitarStockNo');
        const numeroBoletosContainer = document.getElementById('numeroBoletosContainer');
        limitarStockSi.addEventListener('change', function() {
            if (this.checked) {
                numeroBoletosContainer.style.display = 'block';
            }
        });
        limitarStockNo.addEventListener('change', function() {
            if (this.checked) {
                numeroBoletosContainer.style.display = 'none';
            }
        });
    });
</script>
<?php $__env->stopSection(); ?>
<?php endif; ?>


<?php echo $__env->make('layouts/app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\tiendablogauto\resources\views/eventos/dats.blade.php ENDPATH**/ ?>